/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.management.StructureName;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.forgespi.locating.IModFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructureLoadingUtils {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final List<String> originFolders = new ArrayList<String>();
    private static final Map<String, ModFileInfo> originMods = new HashMap<String, ModFileInfo>();
    @NotNull
    private static String latestModOrigin = "structurize";

    private StructureLoadingUtils() {
    }

    public static void addOriginFolder(String folder) {
        originFolders.add(folder);
    }

    public static void addOriginMod(String modId) {
        StructureLoadingUtils.addOriginMod(modId, ModList.get().getModFileById(modId));
    }

    public static void addOriginMod(String modId, ModFileInfo modDescriptor) {
        StructureLoadingUtils.addOriginFolder(modId);
        if (modDescriptor != null) {
            originMods.put(modId, modDescriptor);
        }
    }

    @Nullable
    private static InputStream getStreamFromFolder(@Nullable File folder, String structureName) {
        if (folder == null) {
            return null;
        }
        File blueprintFile = new File(folder.getPath() + "/" + structureName + ".blueprint");
        try {
            if (folder.exists()) {
                if (!blueprintFile.toURI().normalize().getPath().startsWith(folder.toURI().normalize().getPath())) {
                    Log.getLogger().error("Structure: Illegal structure name \"" + structureName + "\"");
                    return null;
                }
                if (blueprintFile.exists()) {
                    return new FileInputStream(blueprintFile);
                }
            }
        }
        catch (FileNotFoundException e) {
            Log.getLogger().error("Structure.getStreamFromFolder", (Throwable)e);
        }
        return null;
    }

    private static InputStream getStreamFromMod(ModFileInfo info, String ... path) {
        Path ret = info.getFile().getLocator().findPath((IModFile)info.getFile(), path);
        if (Files.exists(ret, new LinkOption[0])) {
            try {
                return Files.newInputStream(ret, new OpenOption[0]);
            }
            catch (IOException e) {
                Log.getLogger().warn("Error occured when trying to read resource from: " + info.getFile().getFilePath().toAbsolutePath().toString(), (Throwable)e);
            }
        }
        return null;
    }

    private static InputStream getStreamFromJar(String structureName) {
        String filePath = structureName + ".blueprint";
        InputStream is = StructureLoadingUtils.getStreamFromMod(originMods.get(latestModOrigin), "assets", latestModOrigin, filePath);
        if (is == null) {
            for (Map.Entry<String, ModFileInfo> origin : originMods.entrySet()) {
                String originName = origin.getKey();
                if (originName.equals(latestModOrigin) || (is = StructureLoadingUtils.getStreamFromMod(origin.getValue(), "assets", originName, filePath)) == null) continue;
                latestModOrigin = originName;
                break;
            }
            if (is == null) {
                Log.getLogger().warn("File jar resolve FAILED for: {}", (Object)filePath);
            }
        }
        return is;
    }

    public static byte[] getByteArray(String structureName) {
        InputStream is = StructureLoadingUtils.getStream(structureName);
        byte[] result = StructureLoadingUtils.getStreamAsByteArray(is);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.getLogger().warn("", (Throwable)e);
            }
        }
        return result;
    }

    public static byte[] getStreamAsByteArray(InputStream stream) {
        if (stream == null) {
            return EMPTY_BYTES;
        }
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
        catch (IOException e) {
            Log.getLogger().warn("", (Throwable)e);
            return EMPTY_BYTES;
        }
    }

    @Nullable
    public static InputStream getStream(String structureName) {
        StructureName sn = new StructureName(structureName);
        InputStream inputstream = null;
        if ("cache".equals(sn.getPrefix())) {
            for (File cachedFile : StructureLoadingUtils.getCachedSchematicsFolders()) {
                InputStream stream = StructureLoadingUtils.getStreamFromFolder(cachedFile, structureName);
                if (stream == null) continue;
                return stream;
            }
        } else if ("scans".equals(sn.getPrefix()) && FMLEnvironment.dist == Dist.CLIENT) {
            for (File cachedFile : StructureLoadingUtils.getClientSchematicsFolders()) {
                InputStream stream = StructureLoadingUtils.getStreamFromFolder(cachedFile, structureName);
                if (stream == null) continue;
                return stream;
            }
        } else {
            if (!"schematics".equals(sn.getPrefix())) {
                return null;
            }
            inputstream = StructureLoadingUtils.getStreamFromFolder(Structurize.proxy.getSchematicsFolder(), structureName);
            if (inputstream == null && !((Boolean)Structurize.getConfig().getServer().ignoreSchematicsFromJar.get()).booleanValue()) {
                inputstream = StructureLoadingUtils.getStreamFromJar(structureName);
            }
        }
        return inputstream;
    }

    public static List<File> getCachedSchematicsFolders() {
        ArrayList<File> cachedSchems = new ArrayList<File>();
        for (String origin : originFolders) {
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                if (Manager.getServerUUID() != null) {
                    cachedSchems.add(new File(Minecraft.func_71410_x().field_71412_D, origin + "/" + Manager.getServerUUID()));
                    continue;
                }
                Log.getLogger().error("Manager.getServerUUID() => null this should not happen");
                return null;
            }
            cachedSchems.add(new File(ServerLifecycleHooks.getCurrentServer().func_71238_n() + "/" + "structurize"));
        }
        return cachedSchems;
    }

    public static List<File> getClientSchematicsFolders() {
        ArrayList<File> clientSchems = new ArrayList<File>();
        for (String origin : originFolders) {
            clientSchems.add(new File(Minecraft.func_71410_x().field_71412_D, origin));
        }
        return clientSchems;
    }

    public static List<String> getOriginfolders() {
        return originFolders;
    }

    public static Map<String, ModFileInfo> getOriginMods() {
        return originMods;
    }
}

