/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class StringProperty
extends TeamProperty<String> {
    private final Pattern pattern;

    public StringProperty(ResourceLocation id, String def, @Nullable Pattern p) {
        super(id, def);
        this.pattern = p;
    }

    public StringProperty(ResourceLocation id, String def) {
        this(id, def, null);
    }

    public StringProperty(ResourceLocation id, PacketBuffer buf) {
        super(id, buf.func_150789_c(Short.MAX_VALUE));
        int f = buf.func_150792_a();
        String s = buf.func_150789_c(Short.MAX_VALUE);
        this.pattern = s.isEmpty() ? null : Pattern.compile(s, f);
    }

    @Override
    public TeamPropertyType<String> getType() {
        return TeamPropertyType.STRING;
    }

    @Override
    public Optional<String> fromString(String string) {
        if (this.pattern == null || this.pattern.matcher(string).matches()) {
            return Optional.of(string);
        }
        return Optional.empty();
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_211400_a((String)this.defaultValue, Short.MAX_VALUE);
        buf.func_150787_b(this.pattern == null ? 0 : this.pattern.flags());
        buf.func_211400_a(this.pattern == null ? "" : this.pattern.pattern(), Short.MAX_VALUE);
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<String> value) {
        config.addString(this.id.func_110624_b() + "." + this.id.func_110623_a(), (String)value.value, value.consumer, (String)this.defaultValue, this.pattern);
    }
}

