/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.me.common.GridInventoryEntry;
import appeng.container.me.common.IClientRepo;
import appeng.container.me.common.IncrementalUpdateHelper;
import appeng.container.me.common.MEMonitorableContainer;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.BasePacketHandler;
import appeng.core.sync.network.INetworkInfo;
import com.google.common.base.Preconditions;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MEInventoryUpdatePacket<T extends IAEStack<T>>
extends BasePacket {
    private static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x20000000;
    private static final int INITIAL_BUFFER_CAPACITY = 2048;
    private final List<GridInventoryEntry<T>> list;
    private boolean fullUpdate;
    private int windowId;
    private static final int ITEM_COUNT_FIELD_OFFSET = 4;

    public MEInventoryUpdatePacket(PacketBuffer data) {
        int itemCount = data.readShort();
        this.windowId = data.func_150792_a();
        this.fullUpdate = data.readBoolean();
        this.list = new ArrayList<GridInventoryEntry<T>>(itemCount);
        MEMonitorableContainer<T> container = this.getContainer();
        if (container != null) {
            IStorageChannel<T> storageChannel = container.getStorageChannel();
            for (int i = 0; i < itemCount; ++i) {
                this.list.add(GridInventoryEntry.read(storageChannel, data));
            }
        }
    }

    private MEMonitorableContainer<T> getContainer() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return null;
        }
        Container currentContainer = player.field_71070_bA;
        if (!(currentContainer instanceof MEMonitorableContainer)) {
            return null;
        }
        MEMonitorableContainer meContainer = (MEMonitorableContainer)currentContainer;
        if (meContainer.field_75152_c == this.windowId) {
            return meContainer;
        }
        return null;
    }

    private MEInventoryUpdatePacket() {
        this.list = Collections.emptyList();
    }

    public static <T extends IAEStack<T>> Builder<T> builder(int windowId, boolean fullUpdate) {
        return new Builder(windowId, fullUpdate);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        MEMonitorableContainer<T> container = this.getContainer();
        if (container == null) {
            AELog.info("Ignoring ME inventory update packet because the target container isn't open.", new Object[0]);
            return;
        }
        IClientRepo<T> clientRepo = container.getClientRepo();
        if (clientRepo == null) {
            AELog.info("Ignoring ME inventory update packet because no client repo is available.", new Object[0]);
            return;
        }
        clientRepo.handleUpdate(this.fullUpdate, this.list);
    }

    public static class Builder<T extends IAEStack<T>> {
        private final List<MEInventoryUpdatePacket<T>> packets = new ArrayList<MEInventoryUpdatePacket<T>>();
        private final int windowId;
        @Nullable
        private PacketBuffer data;
        private int itemCount;

        public Builder(int windowId, boolean fullUpdate) {
            this.windowId = windowId;
            this.data = fullUpdate ? this.createPacketHeader(true) : null;
        }

        public void addFull(IncrementalUpdateHelper<T> updateHelper, IItemList<T> stacks) {
            for (IAEStack item : stacks) {
                long serial = updateHelper.getOrAssignSerial(item);
                this.add(new GridInventoryEntry<IAEStack>(serial, item, item.getStackSize(), item.getCountRequestable(), item.isCraftable()));
            }
        }

        public void addChanges(IncrementalUpdateHelper<T> updateHelper, IItemList<T> stacks) {
            for (IAEStack key : updateHelper) {
                IAEStack sendKey;
                Long serial = updateHelper.getSerial(key);
                if (serial == null) {
                    sendKey = key;
                    serial = updateHelper.getOrAssignSerial(key);
                } else {
                    sendKey = null;
                }
                IAEStack stored = stacks.findPrecise(key);
                if (stored == null || !stored.isMeaningful()) {
                    this.add(new GridInventoryEntry<IAEStack>(serial, sendKey, 0L, 0L, false));
                    key.reset();
                    continue;
                }
                this.add(new GridInventoryEntry<IAEStack>(serial, sendKey, stored.getStackSize(), stored.getCountRequestable(), stored.isCraftable()));
            }
            updateHelper.commitChanges();
        }

        public void add(GridInventoryEntry<T> entry) {
            PacketBuffer data = this.ensureData();
            entry.write(data);
            ++this.itemCount;
            if (data.writerIndex() >= 0x20000000 || this.itemCount >= Short.MAX_VALUE) {
                this.flushData();
            }
        }

        private void flushData() {
            if (this.data != null) {
                this.data.markWriterIndex();
                this.data.writerIndex(4);
                this.data.writeShort(this.itemCount);
                this.data.resetWriterIndex();
                MEInventoryUpdatePacket packet = new MEInventoryUpdatePacket();
                packet.configureWrite(this.data);
                this.packets.add(packet);
                this.data = null;
                this.itemCount = 0;
            }
        }

        private PacketBuffer ensureData() {
            if (this.data == null) {
                this.data = this.createPacketHeader(false);
            }
            return this.data;
        }

        private PacketBuffer createPacketHeader(boolean fullUpdate) {
            PacketBuffer data = new PacketBuffer(Unpooled.buffer((int)2048));
            data.writeInt(BasePacketHandler.PacketTypes.ME_INVENTORY_UPDATE.getPacketId());
            Preconditions.checkState((data.writerIndex() == 4 ? 1 : 0) != 0);
            data.writeShort(0);
            data.func_150787_b(this.windowId);
            data.writeBoolean(fullUpdate);
            return data;
        }

        public List<MEInventoryUpdatePacket<T>> build() {
            this.flushData();
            return this.packets;
        }

        public void buildAndSend(Consumer<MEInventoryUpdatePacket<T>> sender) {
            for (MEInventoryUpdatePacket<T> packet : this.build()) {
                sender.accept(packet);
            }
        }
    }
}

