/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.entropy.StateApplier;
import appeng.recipes.entropy.StateMatcher;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

class EntropyRecipeBuilder {
    private ResourceLocation id;
    private EntropyMode mode;
    private Block inputBlock;
    private List<StateMatcher> inputBlockMatchers = Collections.emptyList();
    private Fluid inputFluid;
    private List<StateMatcher> inputFluidMatchers = Collections.emptyList();
    private Block outputBlock;
    private List<StateApplier<?>> outputBlockStateAppliers = Collections.emptyList();
    private boolean outputBlockKeep;
    private Fluid outputFluid;
    private List<StateApplier<?>> outputFluidStateAppliers = Collections.emptyList();
    private boolean outputFluidKeep;
    private List<ItemStack> drops = Collections.emptyList();

    EntropyRecipeBuilder() {
    }

    void setId(ResourceLocation id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0);
        this.id = id;
    }

    void setMode(EntropyMode mode) {
        this.mode = Objects.requireNonNull(mode, "mode must not be null");
    }

    void setInputBlock(Block inputBlock) {
        this.inputBlock = Objects.requireNonNull(inputBlock, "inputBlock must not be null");
    }

    void setInputFluid(Fluid inputFluid) {
        this.inputFluid = Objects.requireNonNull(inputFluid, "inputFluid must not be null");
    }

    void setOutputBlock(Block outputBlock) {
        this.outputBlock = Objects.requireNonNull(outputBlock, "outputBlock must not be null");
    }

    void setOutputBlockKeep(boolean outputBlockKeep) {
        this.outputBlockKeep = outputBlockKeep;
    }

    void setOutputFluid(Fluid outputFluid) {
        this.outputFluid = Objects.requireNonNull(outputFluid, "outputFluid must not be null");
    }

    void setOutputFluidKeep(boolean outputFluidKeep) {
        this.outputFluidKeep = outputFluidKeep;
    }

    void setDrops(List<ItemStack> drops) {
        Preconditions.checkArgument((!drops.isEmpty() ? 1 : 0) != 0, (Object)"drops needs to be a non empty list when set");
        this.drops = drops;
    }

    void addBlockStateMatcher(StateMatcher matcher) {
        Preconditions.checkState((this.inputBlock != null ? 1 : 0) != 0, (Object)"Can only add appliers when an input block is present.");
        if (this.inputBlockMatchers.isEmpty()) {
            this.inputBlockMatchers = new ArrayList<StateMatcher>();
        }
        this.inputBlockMatchers.add(matcher);
    }

    void addFluidStateMatcher(StateMatcher matcher) {
        Preconditions.checkState((this.inputFluid != null ? 1 : 0) != 0, (Object)"Can only add appliers when an input fluid is present.");
        if (this.inputFluidMatchers.isEmpty()) {
            this.inputFluidMatchers = new ArrayList<StateMatcher>();
        }
        this.inputFluidMatchers.add(matcher);
    }

    void addBlockStateAppliers(StateApplier<?> applier) {
        Preconditions.checkState((this.outputBlock != null ? 1 : 0) != 0, (Object)"Can only add appliers when an output block is present.");
        if (this.outputBlockStateAppliers.isEmpty()) {
            this.outputBlockStateAppliers = new ArrayList();
        }
        this.outputBlockStateAppliers.add(applier);
    }

    void addFluidStateAppliers(StateApplier<?> applier) {
        Preconditions.checkState((this.outputFluid != null ? 1 : 0) != 0, (Object)"Can only add appliers when an output fluid is present.");
        if (this.outputFluidStateAppliers.isEmpty()) {
            this.outputFluidStateAppliers = new ArrayList();
        }
        this.outputFluidStateAppliers.add(applier);
    }

    EntropyRecipe build() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0);
        Preconditions.checkState((this.mode != null ? 1 : 0) != 0);
        Preconditions.checkState((this.inputBlock != null || this.inputFluid != null ? 1 : 0) != 0, (Object)"Either inputBlock or inputFluid needs to be not null");
        return new EntropyRecipe(this.id, this.mode, this.inputBlock, this.inputBlockMatchers, this.inputFluid, this.inputFluidMatchers, this.outputBlock, this.outputBlockStateAppliers, this.outputBlockKeep, this.outputFluid, this.outputFluidStateAppliers, this.outputFluidKeep, this.drops);
    }
}

