/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.supermartijn642.configlib.BaseConfigEntry;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;

public class JsonEnumConfigEntry<T extends Enum<T>>
extends BaseConfigEntry<T, JsonElement> {
    private final Class<T> enumClass;

    public JsonEnumConfigEntry(T defaultValue, boolean shouldBeSynced, boolean requiresGameRestart, boolean isClientOnly, boolean isServerOnly, String comment) {
        super(defaultValue, shouldBeSynced, requiresGameRestart, isClientOnly, isServerOnly, comment);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
        for (Enum value : (Enum[])this.enumClass.getEnumConstants()) {
            if (value.name().getBytes(StandardCharsets.UTF_8).length <= 512) continue;
            throw new IllegalArgumentException("Cannot use enum whose values' names are more than 512 bytes!");
        }
    }

    @Override
    public String getAllowedValuesHint() {
        String values = Arrays.stream(this.enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.joining(", "));
        return "Allowed values: " + values + " - Default: " + ((Enum)this.defaultValue).name();
    }

    @Override
    public boolean validateValue(T value) {
        return true;
    }

    @Override
    public JsonElement serialize(T value) {
        return new JsonPrimitive(((Enum)value).name());
    }

    @Override
    public T deserialize(JsonElement serialized) {
        if (!serialized.isJsonPrimitive() || !((JsonPrimitive)serialized).isString()) {
            return null;
        }
        String name = serialized.getAsString();
        T value = null;
        try {
            value = Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public byte[] write(T value) {
        byte[] bytes = ((Enum)value).name().getBytes(StandardCharsets.UTF_8);
        return ByteBuffer.allocate(bytes.length + 4).putInt(bytes.length).put(bytes).array();
    }

    @Override
    public T read(ByteBuffer buffer) {
        int length = buffer.getInt();
        if (length > 512) {
            return null;
        }
        byte[] bytes = new byte[length];
        String name = new String(bytes, StandardCharsets.UTF_8);
        T value = null;
        try {
            value = Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return value;
    }
}

