/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib.toml;

import com.supermartijn642.configlib.toml.BufferedCharReader;
import com.supermartijn642.configlib.toml.MalformedTomlException;
import com.supermartijn642.configlib.toml.TomlElement;
import com.supermartijn642.configlib.toml.TomlPrimitive;
import com.supermartijn642.configlib.toml.TomlTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;

public class TomlDeserializer {
    private final TomlTable contents = new TomlTable();
    private String[] currentTable = new String[0];

    public static TomlTable readTomlTable(BufferedReader reader) throws IOException {
        BufferedCharReader charReader = new BufferedCharReader(reader);
        return new TomlDeserializer().readFile(charReader);
    }

    private TomlDeserializer() {
    }

    private TomlTable readFile(BufferedCharReader reader) throws IOException {
        block5: {
            int character;
            block0: while (true) {
                this.readUntilNextContent(reader);
                character = reader.peekChar();
                if (character == -1) break block5;
                if (character == 91) {
                    this.readTableHeader(reader);
                } else {
                    this.readKeyValuePair(reader);
                }
                while (true) {
                    if (reader.peekChar() == -1) continue block0;
                    if (reader.peekChar() != 32) break;
                    reader.skipChar();
                }
                if (reader.peekChar() == 10) {
                    reader.skipChar();
                    continue;
                }
                if (reader.peekChar() != 35) break;
                reader.skipChar();
                this.skipLine(reader);
            }
            throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Encountered unexpected character '" + (char)character + "'!");
        }
        return this.contents;
    }

    private void readTableHeader(BufferedCharReader reader) throws IOException {
        reader.skipChar();
        if (reader.peekChar() == 91) {
            throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Table arrays are not yet supported!");
        }
        LinkedList<String> key = new LinkedList<String>();
        StringBuilder keyBuilder = new StringBuilder();
        while (true) {
            int character;
            if ((character = reader.peekChar()) == -1 || character == 10) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Missing table header ending ']'!");
            }
            if (character == 32) {
                reader.skipChar();
                continue;
            }
            if (character == 93) {
                if (keyBuilder.length() == 0) {
                    throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Invalid key '" + String.join((CharSequence)".", key) + "." + keyBuilder + "' in table header!");
                }
                break;
            }
            if (character == 39 || character == 34) {
                keyBuilder.append(this.readString(reader));
                continue;
            }
            if (character == 61 || character == 91) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Encountered unexpected character '" + (char)character + "' in table header!");
            }
            if (character == 46) {
                if (keyBuilder.length() == 0) {
                    throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Encountered unexpected character '" + (char)character + "' in table header!");
                }
                key.add(keyBuilder.toString());
                keyBuilder = new StringBuilder();
            } else if (Character.toString((char)character).matches("[A-Za-z0-9_-]")) {
                keyBuilder.append((char)character);
            } else {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Encountered invalid key character '" + (char)character + "' in table header!");
            }
            reader.skipChar();
        }
        reader.skipChar();
        key.add(keyBuilder.toString());
        this.currentTable = key.toArray(new String[0]);
    }

    private void readKeyValuePair(BufferedCharReader reader) throws IOException {
        int character;
        LinkedList<String> key = new LinkedList<String>();
        StringBuilder keyBuilder = new StringBuilder();
        while (true) {
            if ((character = reader.peekChar()) == -1 || character == 10) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Invalid statement '" + String.join((CharSequence)".", key) + "." + keyBuilder + "'!");
            }
            if (character == 32) {
                reader.skipChar();
                continue;
            }
            if (character == 61) {
                if (keyBuilder.length() == 0) {
                    throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Invalid key '" + String.join((CharSequence)".", key) + "." + keyBuilder + "'!");
                }
                break;
            }
            if (character == 39 || character == 34) {
                keyBuilder.append(this.readString(reader));
                continue;
            }
            if (character == 91 || character == 93) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Encountered unexpected character '" + (char)character + "' in key!");
            }
            if (character == 46) {
                if (keyBuilder.length() == 0) {
                    throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Encountered unexpected character '" + (char)character + "' in key!");
                }
                key.add(keyBuilder.toString());
                keyBuilder = new StringBuilder();
            } else if (Character.toString((char)character).matches("[A-Za-z0-9_-]")) {
                keyBuilder.append((char)character);
            } else {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Encountered invalid key character '" + (char)character + "'!");
            }
            reader.skipChar();
        }
        reader.skipChar();
        key.add(keyBuilder.toString());
        character = reader.peekChar();
        while (true) {
            if (character == -1 || character == 10) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Missing value for key '" + String.join((CharSequence)".", key) + "'!");
            }
            if (character != 32) break;
            reader.skipChar();
            character = reader.peekChar();
        }
        if (character == 39 || character == 34) {
            String value = this.readString(reader);
            this.putKeyValue(key.toArray(new String[0]), TomlPrimitive.of(value));
        } else if (character == 43 || character == 45 || Character.isDigit(character)) {
            Number number = this.readNumber(reader);
            if (number instanceof Integer) {
                this.putKeyValue(key.toArray(new String[0]), TomlPrimitive.of((Integer)number));
            } else {
                this.putKeyValue(key.toArray(new String[0]), TomlPrimitive.of((Double)number));
            }
        } else if (reader.peekChars(4).equals("true") || reader.peekChars(5).equals("false")) {
            boolean value = reader.readChars(4).equals("true");
            if (!value) {
                reader.skipChar();
            }
            this.putKeyValue(key.toArray(new String[0]), TomlPrimitive.of(value));
        } else {
            if (character == 91) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Array values are not yet supported!");
            }
            if (character == 123) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Inline tables are not yet supported!");
            }
            throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Encountered unexpected character '" + (char)character + "' whilst reading value!");
        }
    }

    private String readString(BufferedCharReader reader) throws IOException {
        char quoteChar = (char)reader.readChar();
        boolean isBasic = quoteChar == '\"';
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int character;
            if ((character = reader.peekChar()) == -1 || character == 10) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Missing string ending '" + quoteChar + "'!");
            }
            if (character == quoteChar) break;
            if (isBasic && character == 92) {
                stringBuilder.append((char)this.readEscapeSequence(reader));
                continue;
            }
            if (isBasic && (character == 0 || character == 8 || character == 31 || character == 127)) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Invalid basic string character '" + quoteChar + "'!");
            }
            stringBuilder.append((char)character);
            reader.skipChar();
        }
        reader.skipChar();
        return stringBuilder.toString();
    }

    private int readEscapeSequence(BufferedCharReader reader) throws IOException {
        reader.skipChar();
        int character = reader.readChar();
        if (character == -1 || character == 10) {
            throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Unexpected end of line!");
        }
        if (character == 98) {
            return 8;
        }
        if (character == 116) {
            return 9;
        }
        if (character == 110) {
            return 10;
        }
        if (character == 102) {
            return 12;
        }
        if (character == 114) {
            return 13;
        }
        if (character == 101) {
            return 27;
        }
        if (character == 34) {
            return 34;
        }
        if (character == 92) {
            return 92;
        }
        if (character == 117) {
            return this.readUnicodeChar(reader, 4);
        }
        if (character == 85) {
            return this.readUnicodeChar(reader, 8);
        }
        throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Invalid escape sequence '\\" + (char)character + "'!");
    }

    private int readUnicodeChar(BufferedCharReader reader, int length) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int character = reader.readChar();
            if (character == -1) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Unexpected end of file!");
            }
            if (!(Character.isDigit(character) || character >= 97 && character <= 102 || character >= 65 && character <= 70)) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Invalid character '" + (char)character + "' in unicode escape sequence!");
            }
            builder.append((char)character);
        }
        return Integer.parseInt(builder.toString().toUpperCase(Locale.ROOT), 16);
    }

    private Number readNumber(BufferedCharReader reader) throws IOException {
        int character;
        StringBuilder numberBuilder = new StringBuilder();
        while ((character = reader.peekChar()) != -1 && character != 10 && character != 32 && character != 9) {
            if (character == 95) {
                reader.skipChar();
                continue;
            }
            if (Character.isDigit(character) || character >= 97 && character <= 102 || character >= 65 && character <= 70 || character == 120 || character == 111 || character == 45 || character == 43 || character == 46) {
                numberBuilder.append((char)character);
                reader.skipChar();
                continue;
            }
            throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Invalid character '" + (char)character + "' in number!");
        }
        String numberString = numberBuilder.toString();
        if (numberString.startsWith("0x") || numberString.startsWith("0o") || numberString.startsWith("0b")) {
            int base = numberString.startsWith("0x") ? 16 : (numberString.startsWith("0o") ? 8 : 2);
            try {
                return Integer.parseInt(numberString.substring(2), base);
            }
            catch (NumberFormatException ignore) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Not a valid number '" + numberString + "'!");
            }
        }
        if (numberString.contains(".") || numberString.contains("e") || numberString.contains("E")) {
            try {
                return Double.parseDouble(numberString);
            }
            catch (NumberFormatException ignore) {
                throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Not a valid number '" + numberString + "'!");
            }
        }
        try {
            return Integer.parseInt(numberString);
        }
        catch (NumberFormatException ignore) {
            throw new MalformedTomlException("(Line " + reader.getLineIndex() + ":" + reader.getCharIndex() + ") Not a valid number '" + numberString + "'!");
        }
    }

    private void readUntilNextContent(BufferedCharReader reader) throws IOException {
        while (reader.peekChar() != -1) {
            if (reader.peekChar() == 32 || reader.peekChar() == 10 || reader.peekChar() == 9) {
                reader.skipChar();
                continue;
            }
            if (reader.peekChar() != 35) break;
            reader.skipChar();
            this.skipLine(reader);
        }
    }

    private void skipLine(BufferedCharReader reader) throws IOException {
        int character = reader.readChar();
        while (character != -1 && character != 10) {
            character = reader.readChar();
        }
    }

    private void putKeyValue(String[] key, TomlElement value) throws MalformedTomlException {
        CharSequence[] path = new String[this.currentTable.length + key.length];
        System.arraycopy(this.currentTable, 0, path, 0, this.currentTable.length);
        System.arraycopy(key, 0, path, this.currentTable.length, key.length);
        TomlTable object = this.contents;
        for (int i = 0; i < path.length - 1; ++i) {
            TomlElement member = object.get(path[i]);
            if (member == null) {
                TomlTable newObject = new TomlTable();
                object.add(path[i], newObject);
                object = newObject;
                continue;
            }
            if (member.isTable()) {
                object = member.getAsTable();
                continue;
            }
            throw new MalformedTomlException("Conflicting values '" + String.join((CharSequence)".", path) + "' and '" + String.join((CharSequence)".", Arrays.copyOfRange(path, 0, i + 1)) + "'!");
        }
        if (object.get(path[path.length - 1]) != null) {
            throw new MalformedTomlException("Key defined twice '" + String.join((CharSequence)".", path) + "'!");
        }
        object.add(path[path.length - 1], value);
    }
}

