/*
 * Decompiled with CFR 0.152.
 */
package com.ofek2608.crafting_on_a_stick;

import com.ofek2608.crafting_on_a_stick.ItemOnAStick;
import com.ofek2608.crafting_on_a_stick.MinecraftMenuBuilder;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.CartographyContainer;
import net.minecraft.inventory.container.GrindstoneContainer;
import net.minecraft.inventory.container.LoomContainer;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.inventory.container.SmithingTableContainer;
import net.minecraft.inventory.container.StonecutterContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ModItems {
    private static final DeferredRegister<Item> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"crafting_on_a_stick");
    private static final RegistryObject<ItemOnAStick> CRAFTING_TABLE;
    private static final RegistryObject<ItemOnAStick> LOOM;
    private static final RegistryObject<ItemOnAStick> GRINDSTONE;
    private static final RegistryObject<ItemOnAStick> CARTOGRAPHY_TABLE;
    private static final RegistryObject<ItemOnAStick> STONECUTTER;
    private static final RegistryObject<ItemOnAStick> SMITHING_TABLE;
    private static final RegistryObject<ItemOnAStick> ANVIL;
    private static final RegistryObject<ItemOnAStick> CHIPPED_ANVIL;
    private static final RegistryObject<ItemOnAStick> DAMAGED_ANVIL;

    private ModItems() {
    }

    public static void load() {
    }

    private static boolean doPlayerHave(PlayerEntity player, RegistryObject<ItemOnAStick> itemReg) {
        Item item = (Item)itemReg.get();
        PlayerInventory inventory = player.field_71071_by;
        int size = inventory.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack invStack = inventory.func_70301_a(i);
            if (invStack.func_190926_b() || invStack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    private static RegistryObject<ItemOnAStick> createItem(Block block, String containerName, MinecraftMenuBuilder builder) {
        String path = block.getRegistryName().func_110623_a();
        return REGISTER.register(path, () -> new ItemOnAStick(block, containerName, builder));
    }

    private static RegistryObject<ItemOnAStick> createAnvil(Block block) {
        return ModItems.createItem(block, "repair", (a, b, c) -> new RepairContainer(a, b, c){

            public boolean func_75145_c(PlayerEntity player) {
                return ModItems.doPlayerHave(player, (RegistryObject<ItemOnAStick>)DAMAGED_ANVIL) || ModItems.doPlayerHave(player, (RegistryObject<ItemOnAStick>)CHIPPED_ANVIL) || ModItems.doPlayerHave(player, (RegistryObject<ItemOnAStick>)ANVIL);
            }

            protected ItemStack func_230301_a_(PlayerEntity p_150474_, ItemStack p_150475_) {
                if (!p_150474_.field_71075_bZ.field_75098_d) {
                    p_150474_.func_82242_a(-this.func_216976_f());
                }
                float breakChance = ForgeHooks.onAnvilRepair((PlayerEntity)p_150474_, (ItemStack)p_150475_, (ItemStack)this.field_234643_d_.func_70301_a(0), (ItemStack)this.field_234643_d_.func_70301_a(1));
                this.field_234643_d_.func_70299_a(0, ItemStack.field_190927_a);
                if (this.field_82856_l > 0) {
                    ItemStack itemstack = this.field_234643_d_.func_70301_a(1);
                    if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.field_82856_l) {
                        itemstack.func_190918_g(this.field_82856_l);
                        this.field_234643_d_.func_70299_a(1, itemstack);
                    } else {
                        this.field_234643_d_.func_70299_a(1, ItemStack.field_190927_a);
                    }
                } else {
                    this.field_234643_d_.func_70299_a(1, ItemStack.field_190927_a);
                }
                this.setMaximumCost(0);
                this.field_234644_e_.func_221486_a((p_150479_, p_150480_) -> p_150479_.func_217379_c(ModItems.damageAnvil(p_150474_, breakChance) ? 1029 : 1030, p_150480_, 0));
                return p_150475_;
            }
        });
    }

    private static boolean damageAnvil(PlayerEntity player, float breakChance) {
        if (player.field_71075_bZ.field_75098_d || player.func_70681_au().nextFloat() >= breakChance) {
            return false;
        }
        ItemStack candidate = ModItems.damageAnvilItemStack(player.func_184586_b(Hand.MAIN_HAND));
        if (candidate != null) {
            player.func_184611_a(Hand.MAIN_HAND, candidate);
            return candidate.func_190926_b();
        }
        candidate = ModItems.damageAnvilItemStack(player.func_184586_b(Hand.OFF_HAND));
        if (candidate != null) {
            player.func_184611_a(Hand.OFF_HAND, candidate);
            return candidate.func_190926_b();
        }
        PlayerInventory inventory = player.field_71071_by;
        int invSize = inventory.func_70302_i_();
        for (int i = 0; i < invSize; ++i) {
            candidate = ModItems.damageAnvilItemStack(inventory.func_70301_a(i));
            if (candidate == null) continue;
            inventory.func_70299_a(i, candidate);
            return candidate.func_190926_b();
        }
        return false;
    }

    @Nullable
    private static ItemStack damageAnvilItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item == ANVIL.get()) {
            return new ItemStack((IItemProvider)CHIPPED_ANVIL.get());
        }
        if (item == CHIPPED_ANVIL.get()) {
            return new ItemStack((IItemProvider)DAMAGED_ANVIL.get());
        }
        if (item == DAMAGED_ANVIL.get()) {
            return ItemStack.field_190927_a;
        }
        return null;
    }

    static {
        REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        CRAFTING_TABLE = ModItems.createItem(Blocks.field_150462_ai, "crafting", (a, b, c) -> new WorkbenchContainer(a, b, c){

            public boolean func_75145_c(PlayerEntity player) {
                return ModItems.doPlayerHave(player, (RegistryObject<ItemOnAStick>)CRAFTING_TABLE);
            }
        });
        LOOM = ModItems.createItem(Blocks.field_222421_lJ, "loom", (a, b, c) -> new LoomContainer(a, b, c){

            public boolean func_75145_c(PlayerEntity player) {
                return ModItems.doPlayerHave(player, (RegistryObject<ItemOnAStick>)LOOM);
            }
        });
        GRINDSTONE = ModItems.createItem(Blocks.field_222427_lP, "grindstone_title", (a, b, c) -> new GrindstoneContainer(a, b, c){

            public boolean func_75145_c(PlayerEntity player) {
                return ModItems.doPlayerHave(player, (RegistryObject<ItemOnAStick>)GRINDSTONE);
            }
        });
        CARTOGRAPHY_TABLE = ModItems.createItem(Blocks.field_222425_lN, "cartography_table", (a, b, c) -> new CartographyContainer(a, b, c){

            public boolean func_75145_c(PlayerEntity player) {
                return ModItems.doPlayerHave(player, (RegistryObject<ItemOnAStick>)CARTOGRAPHY_TABLE);
            }
        });
        STONECUTTER = ModItems.createItem(Blocks.field_222430_lS, "stonecutter", (a, b, c) -> new StonecutterContainer(a, b, c){

            public boolean func_75145_c(PlayerEntity player) {
                return ModItems.doPlayerHave(player, (RegistryObject<ItemOnAStick>)STONECUTTER);
            }
        });
        SMITHING_TABLE = ModItems.createItem(Blocks.field_222429_lR, "upgrade", (a, b, c) -> new SmithingTableContainer(a, b, c){

            public boolean func_75145_c(PlayerEntity player) {
                return ModItems.doPlayerHave(player, (RegistryObject<ItemOnAStick>)SMITHING_TABLE);
            }
        });
        ANVIL = ModItems.createAnvil(Blocks.field_150467_bQ);
        CHIPPED_ANVIL = ModItems.createAnvil(Blocks.field_196717_eY);
        DAMAGED_ANVIL = ModItems.createAnvil(Blocks.field_196718_eZ);
    }
}

