/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.GemsTags;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.registry.BlockRegistryObject;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.utils.MathUtils;

public enum CorruptedBlocks implements IBlockProvider
{
    STONE(Blocks.field_150348_b, (ITag<Block>)GemsTags.Blocks.CORRUPTABLE_STONE),
    DIRT(Blocks.field_150346_d, (ITag<Block>)GemsTags.Blocks.CORRUPTABLE_DIRT);

    private BlockRegistryObject<Block> block;
    private ItemRegistryObject<Item> pile;
    private final Block purifyBlock;
    private final Predicate<Block> canReplace;

    private CorruptedBlocks(Block purifyBlock, ITag<Block> replaces) {
        this.purifyBlock = purifyBlock;
        this.canReplace = block -> block.func_203417_a(replaces);
    }

    public static void registerBlocks() {
        for (CorruptedBlocks type : CorruptedBlocks.values()) {
            type.block = new BlockRegistryObject(Registration.BLOCKS.register(type.getName(), () -> new CorruptedBlock(type)));
            Registration.ITEMS.register(type.getName(), GemsBlocks.defaultItem(type.block));
        }
    }

    public static void registerItems() {
        for (CorruptedBlocks type : CorruptedBlocks.values()) {
            type.pile = new ItemRegistryObject(Registration.ITEMS.register(type.getName() + "_pile", () -> new Item(new Item.Properties().func_200916_a(GemsItemGroups.MATERIALS))));
        }
    }

    public Block asBlock() {
        return (Block)this.block.get();
    }

    public Item func_199767_j() {
        return this.asBlock().func_199767_j();
    }

    public Item getPile() {
        return (Item)this.pile.get();
    }

    public Block getPurifyBlock() {
        return this.purifyBlock;
    }

    public String getName() {
        return "corrupted_" + this.name().toLowerCase(Locale.ROOT);
    }

    public boolean canReplace(Block block) {
        return this.canReplace.test(block);
    }

    private static class CorruptedBlock
    extends Block {
        private final CorruptedBlocks type;

        CorruptedBlock(CorruptedBlocks type) {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151571_B).func_200943_b(1.0f).func_200947_a(SoundType.field_185849_b).func_235838_a_(state -> 7).func_200944_c());
            this.type = type;
        }

        public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
            if (MathUtils.tryPercentage((Random)rand, (double)0.01)) {
                worldIn.func_180501_a(pos, this.type.purifyBlock.func_176223_P(), 3);
            }
        }

        public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
            tooltip.add((ITextComponent)new TranslationTextComponent("misc.silentgems.dropFromOre", new Object[]{((Item)this.type.pile.get()).func_200296_o()}));
        }
    }
}

