/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.teleporter;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.teleporter.GemTeleporterTileEntity;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.item.ReturnHomeCharmItem;

public class TeleporterBaseBlock
extends Block {
    private final boolean isAnchor;

    public TeleporterBaseBlock(boolean isAnchor) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(15.0f, 2000.0f).func_200947_a(SoundType.field_185852_e));
        this.isAnchor = isAnchor;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new GemTeleporterTileEntity(this.isAnchor);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean holdingReturnHome;
        ItemStack heldItem = player.func_184586_b(hand);
        boolean holdingLinker = !heldItem.func_190926_b() && heldItem.func_77973_b() == GemsItems.TELEPORTER_LINKER.get();
        boolean bl = holdingReturnHome = !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ReturnHomeCharmItem;
        if (world.field_72995_K) {
            return holdingLinker || holdingReturnHome || !this.isAnchor ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        GemTeleporterTileEntity tile = (GemTeleporterTileEntity)world.func_175625_s(pos);
        if (tile == null) {
            SilentGems.LOGGER.warn("Teleporter tile at {} not found!", (Object)pos);
            return ActionResultType.PASS;
        }
        return tile.interact(player, heldItem, hand) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }
}

