/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.gear;

import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.TraitHelper;

public final class SGearCompat {
    private SGearCompat() {
        throw new IllegalAccessError("Utility class");
    }

    public static String getGradeString(ItemStack stack) {
        MaterialGrade grade = MaterialGrade.fromStack((ItemStack)stack);
        return grade.name();
    }

    public static int getPartTier(ItemStack stack) {
        PartData part = PartData.from((ItemStack)stack);
        return part != null ? part.getTier() : -1;
    }

    public static boolean isMainPart(ItemStack stack) {
        PartData part = PartData.from((ItemStack)stack);
        return part != null && part.getType() == PartType.MAIN;
    }

    public static int getTraitLevel(ItemStack stack, ResourceLocation traitId) {
        return TraitHelper.getTraitLevel((ItemStack)stack, (ResourceLocation)traitId);
    }

    public static boolean isMaterial(ItemStack stack) {
        return MaterialManager.from((ItemStack)stack) != null;
    }

    public static int getMaterialTier(ItemStack stack) {
        IMaterial material = MaterialManager.from((ItemStack)stack);
        return material != null ? material.getTier(PartType.MAIN) : -1;
    }
}

