/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.lib.soul.Soul;

public class SoulGemIngredient
extends Ingredient {
    private final ResourceLocation soulId;

    public SoulGemIngredient(ResourceLocation soulId) {
        super(Stream.of(new Ingredient.SingleItemList(SoulGemItem.getStack(soulId))));
        this.soulId = soulId;
    }

    public static SoulGemIngredient of(ResourceLocation soulId) {
        return new SoulGemIngredient(soulId);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        Soul soul = Soul.from(this.soulId);
        return soul != null && stack.func_77973_b() instanceof SoulGemItem && soul == SoulGemItem.getSoul(stack);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("soul", this.soulId.toString());
        return json;
    }

    public static final class Serializer
    implements IIngredientSerializer<SoulGemIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGems.getId("soul_gem");

        public SoulGemIngredient parse(PacketBuffer buffer) {
            ResourceLocation soulId = buffer.func_192575_l();
            return new SoulGemIngredient(soulId);
        }

        public SoulGemIngredient parse(JsonObject json) {
            String soulIdStr = JSONUtils.func_151200_h((JsonObject)json, (String)"soul");
            ResourceLocation soulId = new ResourceLocation(soulIdStr);
            return new SoulGemIngredient(soulId);
        }

        public void write(PacketBuffer buffer, SoulGemIngredient ingredient) {
            buffer.func_192572_a(ingredient.soulId);
        }

        public static void register() {
            CraftingHelper.register((ResourceLocation)NAME, (IIngredientSerializer)INSTANCE);
        }
    }
}

