/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data.recipe;

import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.ImpossibleTrigger;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.block.MiscBlocks;
import net.silentchaos512.gems.block.MiscOres;
import net.silentchaos512.gems.crafting.ingredient.SoulGemIngredient;
import net.silentchaos512.gems.data.recipe.TokenEnchantingRecipeBuilder;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.GemsEnchantments;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.init.GemsRecipeInit;
import net.silentchaos512.gems.init.GemsTags;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.ModFoods;
import net.silentchaos512.gems.item.SoulUrnUpgrades;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.soul.Soul;
import net.silentchaos512.lib.data.ExtendedShapedRecipeBuilder;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.utils.Color;

public class GemsRecipeProvider
extends RecipeProvider {
    public GemsRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String func_200397_b() {
        return "Silent's Gems - Recipes";
    }

    protected void func_208310_b(DirectoryCache cache, JsonObject advancementJson, Path pathIn) {
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.registerCraftingItemsAndRandoms(consumer);
        this.registerGemRecipes(consumer);
        GemsRecipeProvider.registerSpecialRecipes(consumer);
        this.registerTokenEnchanting(consumer);
        this.registerFluffyStuff(consumer);
        this.smeltingAndBlasting(consumer, "chaos_ore", (IItemProvider)MiscOres.CHAOS, (IItemProvider)CraftingItems.CHAOS_CRYSTAL);
        this.smeltingAndBlasting(consumer, "ender_ore", (IItemProvider)MiscOres.ENDER, (IItemProvider)CraftingItems.ENDER_CRYSTAL);
        this.smeltingAndBlasting(consumer, "silver_ore", (IItemProvider)MiscOres.SILVER, (IItemProvider)CraftingItems.SILVER_INGOT);
        this.pedestal(consumer, (IItemProvider)GemsBlocks.ANDESITE_PEDESTAL, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221579_g}));
        this.pedestal(consumer, (IItemProvider)GemsBlocks.GRANITE_PEDESTAL, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221575_c}));
        this.pedestal(consumer, (IItemProvider)GemsBlocks.DIORITE_PEDESTAL, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221577_e}));
        this.pedestal(consumer, (IItemProvider)GemsBlocks.STONE_PEDESTAL, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221574_b}));
        this.pedestal(consumer, (IItemProvider)GemsBlocks.OBSIDIAN_PEDESTAL, Ingredient.func_199805_a((ITag)Tags.Items.OBSIDIAN));
        this.soulUrn(consumer, (IItemProvider)Blocks.field_150405_ch, 9985861, "");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196777_fo, 13742497, "white");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196778_fp, 10507045, "orange");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196780_fq, 9787244, "magenta");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196782_fr, 7367818, "light_blue");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196783_fs, 12157987, "yellow");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196785_ft, 6780212, "lime");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196787_fu, 10505550, "pink");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196789_fv, 3746340, "gray");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196791_fw, 8874593, "light_gray");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196793_fx, 5659227, "cyan");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196795_fy, 7750998, "purple");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196797_fz, 4864859, "blue");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196719_fA, 5059108, "brown");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196720_fB, 4936234, "green");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196721_fC, 9321518, "red");
        this.soulUrn(consumer, (IItemProvider)Blocks.field_196722_fD, 2430480, "black");
        ShapedRecipeBuilder.func_200470_a(GemsItems.CHAOS_POTATO).func_200472_a(" / ").func_200472_a("/#/").func_200472_a(" / ").func_200462_a(Character.valueOf('/'), (IItemProvider)CraftingItems.CHAOS_CRYSTAL_SHARD).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151174_bG).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsItems.FRAGILE_CHAOS_ORB).func_200472_a(" / ").func_200472_a("/#/").func_200472_a(" / ").func_200469_a(Character.valueOf('/'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('#'), GemsTags.Items.GEMS_CHAOS).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsItems.REFINED_CHAOS_ORB).func_200472_a("/").func_200472_a("#").func_200472_a("/").func_200462_a(Character.valueOf('/'), (IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL).func_200462_a(Character.valueOf('#'), GemsItems.FRAGILE_CHAOS_ORB).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a(GemsItems.PERFECT_CHAOS_ORB).func_200487_b(GemsItems.REFINED_CHAOS_ORB).func_200487_b(GemsItems.SOUL_GEM).func_200487_b(GemsItems.PURIFYING_POWDER).func_200487_b(GemsItems.PURIFYING_POWDER).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)CraftingItems.CHARGING_AGENT, (int)2).func_200472_a("#g#").func_200472_a("#l#").func_200472_a("#g#").func_200469_a(Character.valueOf('#'), GemsTags.Items.GEMS_CHAOS).func_200469_a(Character.valueOf('g'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('l'), (ITag)Tags.Items.GEMS_LAPIS).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)CraftingItems.SUPER_CHARGING_AGENT, (int)2).func_200472_a("#f#").func_200472_a("aea").func_200472_a("#f#").func_200469_a(Character.valueOf('#'), GemsTags.Items.GEMS_CHAOS).func_200462_a(Character.valueOf('f'), (IItemProvider)Items.field_185161_cS).func_200462_a(Character.valueOf('a'), (IItemProvider)CraftingItems.CHARGING_AGENT).func_200462_a(Character.valueOf('e'), (IItemProvider)Items.field_151061_bv).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)CraftingItems.ULTRA_CHARGING_AGENT, (int)2).func_200472_a("#e#").func_200472_a("ana").func_200472_a("#e#").func_200469_a(Character.valueOf('#'), GemsTags.Items.GEMS_CHAOS).func_200462_a(Character.valueOf('e'), (IItemProvider)CraftingItems.ENDER_CRYSTAL).func_200462_a(Character.valueOf('a'), (IItemProvider)CraftingItems.SUPER_CHARGING_AGENT).func_200462_a(Character.valueOf('n'), (IItemProvider)CraftingItems.NETHER_STAR_SHARD).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsItems.CHAOS_METER).func_200472_a("#c#").func_200472_a("#/#").func_200472_a("d d").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('c'), (IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL).func_200469_a(Character.valueOf('/'), (ITag)Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('d'), GemsTags.Items.CORRUPTED_DUSTS).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.CORRUPTED_DUSTS)).func_200464_a(consumer);
        for (CorruptedBlocks block : CorruptedBlocks.values()) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)block).func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), (IItemProvider)block.getPile()).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)block.getPile())).func_200464_a(consumer);
        }
        ShapedRecipeBuilder.func_200470_a(GemsBlocks.LUMINOUS_FLOWER_POT).func_200472_a("c").func_200472_a("#").func_200462_a(Character.valueOf('c'), (IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_222087_nH).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsBlocks.PURIFIER).func_200472_a("ada").func_200472_a("clc").func_200472_a("###").func_200462_a(Character.valueOf('a'), GemsItems.PURIFYING_POWDER).func_200469_a(Character.valueOf('d'), (ITag)Tags.Items.GEMS_DIAMOND).func_200462_a(Character.valueOf('c'), (IItemProvider)CraftingItems.CHAOS_IRON_INGOT).func_200462_a(Character.valueOf('l'), (IItemProvider)Items.field_221695_cJ).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.OBSIDIAN).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsBlocks.SUPERCHARGER).func_200472_a("ada").func_200472_a("clc").func_200472_a("###").func_200469_a(Character.valueOf('a'), GemsTags.Items.INGOTS_SILVER).func_200469_a(Character.valueOf('d'), (ITag)Tags.Items.GEMS_DIAMOND).func_200462_a(Character.valueOf('c'), (IItemProvider)CraftingItems.CHAOS_IRON_INGOT).func_200469_a(Character.valueOf('l'), (ITag)Tags.Items.STORAGE_BLOCKS_LAPIS).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.OBSIDIAN).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.CHAOS_IRON_INGOT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsBlocks.TOKEN_ENCHANTER).func_200472_a("oeo").func_200472_a("clc").func_200472_a("###").func_200462_a(Character.valueOf('o'), (IItemProvider)CraftingItems.BLANK_TOKEN).func_200469_a(Character.valueOf('e'), (ITag)Tags.Items.GEMS_EMERALD).func_200462_a(Character.valueOf('c'), (IItemProvider)CraftingItems.CHAOS_IRON_INGOT).func_200469_a(Character.valueOf('l'), (ITag)Tags.Items.STORAGE_BLOCKS_LAPIS).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.OBSIDIAN).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.CHAOS_IRON_INGOT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsBlocks.TRANSMUTATION_ALTAR).func_200472_a("cdc").func_200472_a("cgc").func_200472_a("###").func_200462_a(Character.valueOf('c'), (IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL).func_200469_a(Character.valueOf('d'), (ITag)Tags.Items.GEMS_DIAMOND).func_200462_a(Character.valueOf('g'), (IItemProvider)Items.field_221695_cJ).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.OBSIDIAN).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a(GemsBlocks.TELEPORTER_ANCHOR, (int)4).func_200472_a("cec").func_200472_a(" # ").func_200472_a("cec").func_200462_a(Character.valueOf('c'), (IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL).func_200469_a(Character.valueOf('e'), (ITag)Tags.Items.ENDER_PEARLS).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STORAGE_BLOCKS_IRON).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL)).func_200467_a(consumer, SilentGems.getId("teleporter/anchor"));
        ShapedRecipeBuilder.func_200470_a(GemsItems.TELEPORTER_LINKER).func_200472_a("#").func_200472_a("/").func_200472_a("/").func_200462_a(Character.valueOf('#'), (IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL).func_200469_a(Character.valueOf('/'), (ITag)Tags.Items.INGOTS_GOLD).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL)).func_200464_a(consumer);
        ExtendedShapedRecipeBuilder.builder((IRecipeSerializer)((IRecipeSerializer)GemsRecipeInit.GEAR_SOUL_RECIPE.get()), GemsItems.GEAR_SOUL).patternLine(" # ").patternLine("#s#").patternLine(" # ").key(Character.valueOf('#'), GemsItems.SOUL_GEM).key(Character.valueOf('s'), (IItemProvider)CraftingItems.SOUL_SHELL).build(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsItems.GEM_BAG).func_200472_a("~~~").func_200472_a("#g#").func_200472_a("###").func_200462_a(Character.valueOf('~'), (IItemProvider)CraftingItems.GILDED_STRING).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199904_a).func_200469_a(Character.valueOf('g'), (ITag)Tags.Items.GEMS).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a((ITag)Tags.Items.GEMS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsItems.GLOWROSE_BASKET).func_200472_a("~~~").func_200472_a("#g#").func_200472_a("###").func_200462_a(Character.valueOf('~'), (IItemProvider)CraftingItems.GILDED_STRING).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222065_kN, Items.field_222068_kQ})).func_200469_a(Character.valueOf('g'), GemsTags.Items.GLOWROSES).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GLOWROSES)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a(GemsItems.GLOWROSE_FERTILIZER, (int)4).func_200472_a("###").func_200472_a("#/#").func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_196106_bc).func_200469_a(Character.valueOf('/'), GemsTags.Items.GEMS_CHAOS).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsItems.SUMMON_KITTY).func_200472_a("|f|").func_200472_a("|g|").func_200472_a("|f|").func_200469_a(Character.valueOf('|'), (ITag)Tags.Items.STRING).func_200469_a(Character.valueOf('f'), GemsTags.Items.STEW_FISH).func_200469_a(Character.valueOf('g'), GemsTags.Items.GEMS).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(GemsItems.SUMMON_PUPPY).func_200472_a(" m ").func_200472_a("#g#").func_200472_a(" m ").func_200469_a(Character.valueOf('m'), GemsTags.Items.STEW_FISH).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.LEATHER).func_200469_a(Character.valueOf('g'), GemsTags.Items.GEMS).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS)).func_200464_a(consumer);
    }

    private void registerCraftingItemsAndRandoms(Consumer<IFinishedRecipe> consumer) {
        this.compression(consumer, CraftingItems.CHAOS_CRYSTAL, CraftingItems.CHAOS_CRYSTAL_SHARD);
        this.compression(consumer, CraftingItems.ENDER_CRYSTAL, CraftingItems.ENDER_CRYSTAL_SHARD);
        this.compression(consumer, CraftingItems.SILVER_INGOT, CraftingItems.SILVER_NUGGET);
        this.compression(consumer, (IItemProvider)MiscBlocks.CHAOS_COAL, CraftingItems.CHAOS_COAL, "storage_blocks/chaos_coal");
        this.compression(consumer, (IItemProvider)MiscBlocks.CHAOS_CRYSTAL, CraftingItems.CHAOS_CRYSTAL, "storage_blocks/chaos_crystal");
        this.compression(consumer, (IItemProvider)MiscBlocks.ENRICHED_CHAOS_CRYSTAL, CraftingItems.ENRICHED_CHAOS_CRYSTAL, "storage_blocks/enriched_chaos_crystal");
        this.compression(consumer, (IItemProvider)MiscBlocks.ENDER_CRYSTAL, CraftingItems.ENDER_CRYSTAL, "storage_blocks/ender_crystal");
        this.compression(consumer, (IItemProvider)MiscBlocks.SILVER, CraftingItems.SILVER_INGOT, "storage_blocks/silver");
        this.compression(consumer, (IItemProvider)MiscBlocks.CHAOS_IRON, CraftingItems.CHAOS_IRON_INGOT, "storage_blocks/chaos_iron");
        this.compression(consumer, (IItemProvider)MiscBlocks.CHAOS_GOLD, CraftingItems.CHAOS_GOLD_INGOT, "storage_blocks/chaos_gold");
        this.compression(consumer, (IItemProvider)MiscBlocks.CHAOS_SILVER, CraftingItems.CHAOS_SILVER_INGOT, "storage_blocks/chaos_silver");
        this.chaosMetalDust(consumer, CraftingItems.CHAOS_IRON_DUST, CraftingItems.CHAOS_IRON_INGOT, (ITag<Item>)Tags.Items.INGOTS_IRON);
        this.chaosMetalDust(consumer, CraftingItems.CHAOS_GOLD_DUST, CraftingItems.CHAOS_GOLD_INGOT, (ITag<Item>)Tags.Items.INGOTS_GOLD);
        this.chaosMetalDust(consumer, CraftingItems.CHAOS_SILVER_DUST, CraftingItems.CHAOS_SILVER_INGOT, (ITag<Item>)GemsTags.Items.INGOTS_SILVER);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)CraftingItems.BLANK_TOKEN, (int)12).func_200472_a("///").func_200472_a("clc").func_200472_a("///").func_200469_a(Character.valueOf('/'), (ITag)Tags.Items.INGOTS_GOLD).func_200469_a(Character.valueOf('c'), GemsTags.Items.GEMS_CHAOS).func_200469_a(Character.valueOf('l'), (ITag)Tags.Items.GEMS_LAPIS).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)CraftingItems.CHAOS_DUST, (int)2).func_203221_a(GemsTags.Items.GEMS_CHAOS).func_203221_a(GemsTags.Items.GEMS_CHAOS).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)CraftingItems.GILDED_STRING, (int)3).func_200472_a("#|#").func_200472_a("#|#").func_200472_a("#|#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.NUGGETS_GOLD).func_200469_a(Character.valueOf('|'), (ITag)Tags.Items.STRING).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a((ITag)Tags.Items.NUGGETS_GOLD)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)CraftingItems.MYSTERY_GOO).func_200472_a("k#k").func_200472_a("#a#").func_200472_a("k#k").func_200462_a(Character.valueOf('k'), (IItemProvider)Items.field_222066_kO).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221653_bO).func_200462_a(Character.valueOf('a'), (IItemProvider)Items.field_151034_e).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)Items.field_221653_bO)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151156_bN).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)CraftingItems.NETHER_STAR_SHARD).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)Items.field_151156_bN)).func_200467_a(consumer, SilentGems.getId("nether_star"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)CraftingItems.RUNE_SLATE, (int)2).func_200472_a("#/#").func_200472_a("/o/").func_200472_a("#/#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200462_a(Character.valueOf('/'), (IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL).func_200469_a(Character.valueOf('o'), GemsTags.Items.INGOTS_SILVER).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)CraftingItems.SOUL_SHELL, (int)2).func_200472_a(" # ").func_200472_a("#o#").func_200472_a(" # ").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('o'), (ITag)Tags.Items.GEMS_DIAMOND).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a((ITag)Tags.Items.GEMS_DIAMOND)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151123_aH).func_203221_a((ITag)Tags.Items.SLIMEBALLS).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a((ITag)Tags.Items.SLIMEBALLS)).func_200485_a(consumer, SilentGems.getId("slime_ball"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)ModFoods.POTATO_ON_A_STICK).func_200472_a(" p").func_200472_a("/ ").func_200462_a(Character.valueOf('p'), (IItemProvider)Items.field_151168_bH).func_200469_a(Character.valueOf('/'), (ITag)Tags.Items.RODS_WOODEN).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)Items.field_151168_bH)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)ModFoods.SUGAR_COOKIE, (int)8).func_200472_a(" S ").func_200472_a("///").func_200472_a(" S ").func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151102_aT).func_200462_a(Character.valueOf('/'), (IItemProvider)Items.field_151015_O).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)Items.field_151102_aT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)ModFoods.CANDY_CANE, (int)8).func_200472_a("ss").func_200472_a("rs").func_200472_a(" s").func_200462_a(Character.valueOf('s'), (IItemProvider)Items.field_151102_aT).func_200469_a(Character.valueOf('r'), (ITag)Tags.Items.DYES_RED).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)Items.field_151102_aT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)ModFoods.IRON_POTATO).func_200472_a("/#/").func_200472_a("#p#").func_200472_a("/#/").func_200462_a(Character.valueOf('/'), (IItemProvider)CraftingItems.CHAOS_IRON_INGOT).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STORAGE_BLOCKS_IRON).func_200462_a(Character.valueOf('p'), (IItemProvider)Items.field_151174_bG).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)Items.field_151174_bG)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)ModFoods.SECRET_DONUT, (int)6).func_200472_a("///").func_200472_a("/m/").func_200472_a("///").func_200462_a(Character.valueOf('/'), (IItemProvider)Items.field_151015_O).func_200462_a(Character.valueOf('m'), (IItemProvider)Items.field_221694_bi).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)Items.field_221694_bi)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)ModFoods.UNCOOKED_FISHY_STEW).func_200487_b((IItemProvider)Items.field_151054_z).func_203221_a(GemsTags.Items.STEW_FISH).func_200487_b((IItemProvider)Items.field_203180_bP).func_200487_b((IItemProvider)Items.field_221692_bh).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.STEW_FISH)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)ModFoods.UNCOOKED_MEATY_STEW).func_200487_b((IItemProvider)Items.field_151054_z).func_203221_a(GemsTags.Items.STEW_MEAT).func_200487_b((IItemProvider)Items.field_151174_bG).func_200487_b((IItemProvider)Items.field_151172_bF).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.STEW_MEAT)).func_200482_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModFoods.UNCOOKED_FISHY_STEW}), (IItemProvider)ModFoods.FISHY_STEW, (float)0.45f, (int)200).func_218628_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.STEW_FISH)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModFoods.UNCOOKED_MEATY_STEW}), (IItemProvider)ModFoods.MEATY_STEW, (float)0.45f, (int)200).func_218628_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.STEW_MEAT)).func_218630_a(consumer);
    }

    private void registerGemRecipes(Consumer<IFinishedRecipe> consumer) {
        for (Gems gem : Gems.values()) {
            String name = gem.getName();
            this.smeltingAndBlasting(consumer, NameUtils.from((IForgeRegistryEntry)gem.getOre()).func_110623_a(), (ITag<Item>)gem.getOreItemTag(), (IItemProvider)gem.getItem());
            this.compression(consumer, (IItemProvider)gem.getItem(), (IItemProvider)gem.getShard(), "gems/" + name);
            this.compression(consumer, (IItemProvider)gem.getBlock(), (IItemProvider)gem.getItem(), "gems/" + name + "_block");
            ShapedRecipeBuilder.func_200468_a((IItemProvider)gem.getBricks(), (int)5).func_200473_b(gem.getSet().getName() + "_gem_bricks").func_200472_a("/#/").func_200472_a("###").func_200472_a("/#/").func_200469_a(Character.valueOf('/'), gem.getShardTag()).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221723_cX).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)Items.field_221723_cX)).func_200467_a(consumer, SilentGems.getId("bricks/" + name));
            ShapedRecipeBuilder.func_200468_a((IItemProvider)gem.getGlass(), (int)5).func_200473_b(gem.getSet().getName() + "_gem_glass").func_200472_a("/#/").func_200472_a("###").func_200472_a("/#/").func_200469_a(Character.valueOf('/'), gem.getShardTag()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a((ITag)Tags.Items.GLASS)).func_200467_a(consumer, SilentGems.getId("glass/" + name));
            ShapedRecipeBuilder.func_200470_a((IItemProvider)gem.getReturnHomeCharm()).func_200473_b(gem.getSet().getName() + "_return_home_charms").func_200472_a(" / ").func_200472_a("/g/").func_200472_a("#o#").func_200462_a(Character.valueOf('/'), (IItemProvider)CraftingItems.GILDED_STRING).func_200469_a(Character.valueOf('g'), gem.getItemTag()).func_200469_a(Character.valueOf('#'), GemsTags.Items.GEMS_CHAOS).func_200469_a(Character.valueOf('o'), (ITag)Tags.Items.ENDER_PEARLS).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.GEMS_CHAOS)).func_200466_a(consumer, "return_home_charm/" + name);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)gem.getLamp(GemLampBlock.State.UNLIT)).func_200473_b(gem.getSet().getName() + "_gem_lamps").func_200472_a("rgr").func_200472_a("g#g").func_200472_a("rgr").func_200469_a(Character.valueOf('r'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('g'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('#'), gem.getItemTag()).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a((ITag)Tags.Items.DUSTS_GLOWSTONE)).func_200466_a(consumer, "lamp/" + name);
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)gem.getLamp(GemLampBlock.State.INVERTED_LIT)).func_200490_a(gem.getSet().getName() + "_inverted_gem_lamps").func_200487_b((IItemProvider)gem.getLamp(GemLampBlock.State.UNLIT)).func_200487_b((IItemProvider)Items.field_221764_cr).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a((ITag)Tags.Items.DUSTS_GLOWSTONE)).func_200484_a(consumer, "lamp/" + name + "_inverted");
            ShapedRecipeBuilder.func_200468_a((IItemProvider)gem.getTeleporter(), (int)2).func_200473_b(gem.getSet().getName() + "_gem_teleporters").func_200472_a("cec").func_200472_a(" # ").func_200472_a("cec").func_200462_a(Character.valueOf('c'), (IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL).func_200469_a(Character.valueOf('e'), GemsTags.Items.TELEPORTER_CATALYST).func_200469_a(Character.valueOf('#'), gem.getBlockItemTag()).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.TELEPORTER_CATALYST)).func_200467_a(consumer, SilentGems.getId("teleporter/standard/" + name));
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)gem.getRedstoneTeleporter(), (int)1).func_200490_a(gem.getSet().getName() + "_gem_redstone_teleporters").func_200487_b((IItemProvider)gem.getTeleporter()).func_203221_a((ITag)Tags.Items.DUSTS_REDSTONE).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(GemsTags.Items.TELEPORTER_CATALYST)).func_200485_a(consumer, SilentGems.getId("teleporter/redstone/" + name));
        }
    }

    private void smeltingAndBlasting(Consumer<IFinishedRecipe> consumer, String id, IItemProvider ingredientItem, IItemProvider result) {
        Ingredient ingredientIn = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredientItem});
        this.smeltingAndBlasting(consumer, id, ingredientIn, result);
    }

    private void smeltingAndBlasting(Consumer<IFinishedRecipe> consumer, String id, ITag<Item> ingredientTag, IItemProvider result) {
        Ingredient ingredientIn = Ingredient.func_199805_a(ingredientTag);
        this.smeltingAndBlasting(consumer, id, ingredientIn, result);
    }

    private void smeltingAndBlasting(Consumer<IFinishedRecipe> consumer, String id, Ingredient ingredientIn, IItemProvider result) {
        CookingRecipeBuilder.func_218633_b((Ingredient)ingredientIn, (IItemProvider)result, (float)1.0f, (int)100).func_218628_a("impossible", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_218635_a(consumer, SilentGems.getId("blasting/" + id));
        CookingRecipeBuilder.func_218629_c((Ingredient)ingredientIn, (IItemProvider)result, (float)1.0f, (int)200).func_218628_a("impossible", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_218635_a(consumer, SilentGems.getId("smelting/" + id));
    }

    private void compression(Consumer<IFinishedRecipe> consumer, IItemProvider large, IItemProvider small) {
        this.compression(consumer, large, small, NameUtils.fromItem((IItemProvider)large).func_110623_a());
    }

    private void compression(Consumer<IFinishedRecipe> consumer, IItemProvider large, IItemProvider small, String path) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)large, (int)1).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), small).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)large)).func_200467_a(consumer, SilentGems.getId(path + "_compress"));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)small, (int)9).func_200487_b(large).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)large)).func_200485_a(consumer, SilentGems.getId(path + "_decompress"));
    }

    private void chaosMetalDust(Consumer<IFinishedRecipe> consumer, IItemProvider dust, IItemProvider ingot, ITag<Item> baseMetal) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)dust, (int)1).func_200472_a("#").func_200472_a("/").func_200472_a("#").func_200462_a(Character.valueOf('#'), (IItemProvider)CraftingItems.CHAOS_DUST).func_200469_a(Character.valueOf('/'), baseMetal).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200409_a(baseMetal)).func_200464_a(consumer);
        this.smeltingAndBlasting(consumer, NameUtils.fromItem((IItemProvider)ingot).func_110623_a(), dust, ingot);
    }

    private void pedestal(Consumer<IFinishedRecipe> consumer, IItemProvider pedestal, Ingredient material) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)pedestal).func_200472_a("#/#").func_200472_a(" # ").func_200472_a("###").func_200471_a(Character.valueOf('#'), material).func_200462_a(Character.valueOf('/'), (IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.ENRICHED_CHAOS_CRYSTAL)).func_200464_a(consumer);
    }

    private void soulUrn(Consumer<IFinishedRecipe> consumer, IItemProvider terracotta, int color, String suffix) {
        ExtendedShapedRecipeBuilder.builder((IRecipeSerializer)((IRecipeSerializer)GemsRecipeInit.SOUL_URN.get()), GemsBlocks.SOUL_URN).addExtraData(json -> json.addProperty("urn_clay_color", Color.format((int)color))).setGroup("silentgems:soul_urns").patternLine("#g#").patternLine("#s#").patternLine("###").key(Character.valueOf('#'), terracotta).key(Character.valueOf('g'), GemsTags.Items.GEMS).key(Character.valueOf('s'), GemsItems.SOUL_GEM).build(consumer, SilentGems.getId("soul_urn" + (!suffix.isEmpty() ? "_" + suffix : "")));
    }

    private static void registerSpecialRecipes(Consumer<IFinishedRecipe> consumer) {
        GemsRecipeProvider.customRecipe(consumer, GemsRecipeInit.APPLY_CHAOS_RUNE);
        GemsRecipeProvider.customRecipe(consumer, GemsRecipeInit.APPLY_ENCHANTMENT_TOKEN);
        GemsRecipeProvider.customRecipe(consumer, GemsRecipeInit.MODIFY_SOUL_URN);
    }

    private static void customRecipe(Consumer<IFinishedRecipe> consumer, RegistryObject<SpecialRecipeSerializer<?>> serializer) {
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)serializer.get())).func_200499_a(consumer, serializer.getId().toString());
    }

    private void registerTokenEnchanting(Consumer<IFinishedRecipe> consumer) {
        for (Gems gem : Gems.values()) {
            TokenEnchantingRecipeBuilder.builder((IItemProvider)gem.getChaosGem(), 1, 3333, 300).token((ITag<Item>)gem.getBlockItemTag()).addIngredient(CraftingItems.ENRICHED_CHAOS_CRYSTAL, 10).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_gem/" + gem.getName()));
        }
        for (SpawnEggItem spawnEggItem : SpawnEggItem.func_195985_g()) {
            EntityType type = spawnEggItem.func_208076_b(new CompoundNBT());
            if (!Soul.canHaveSoulGem(type)) continue;
            ResourceLocation typeId = NameUtils.from((IForgeRegistryEntry)type);
            TokenEnchantingRecipeBuilder.builder((IItemProvider)spawnEggItem, 1, 1000, 200).token((IItemProvider)Items.field_151110_aK).addIngredient(SoulGemIngredient.of(typeId), 4).addIngredient(CraftingItems.ENRICHED_CHAOS_CRYSTAL, 4).build(consumer, GemsRecipeProvider.idTokenEnchanting("spawn_egg/" + typeId.func_110623_a()));
        }
        TokenEnchantingRecipeBuilder.builder(CraftingItems.URN_UPGRADE_BASE, 4, 100, 20).token((IItemProvider)Blocks.field_150405_ch).addIngredient(CraftingItems.ENRICHED_CHAOS_CRYSTAL, 1).build(consumer, GemsRecipeProvider.idTokenEnchanting("urn/upgrade_base"));
        TokenEnchantingRecipeBuilder.builder(SoulUrnUpgrades.PLANTER, 1, 500, 100).token(CraftingItems.URN_UPGRADE_BASE).addIngredient((IItemProvider)Blocks.field_150346_d, 10).addIngredient((IItemProvider)Items.field_196106_bc, 30).addIngredient((ITag<Item>)GemsTags.Items.GLOWROSES, 2).build(consumer, GemsRecipeProvider.idTokenEnchanting("urn/planter_upgrade"));
        TokenEnchantingRecipeBuilder.builder(SoulUrnUpgrades.VACUUM, 1, 500, 100).token(CraftingItems.URN_UPGRADE_BASE).addIngredient((IItemProvider)Items.field_151061_bv, 2).addIngredient((IItemProvider)Items.field_221862_eo, 1).build(consumer, GemsRecipeProvider.idTokenEnchanting("urn/vacuum_upgrade"));
        TokenEnchantingRecipeBuilder.builder(CraftingItems.CHAOS_COAL, 8, 250, 20).token((ITag<Item>)GemsTags.Items.GEMS_CHAOS).addIngredient((IItemProvider)Items.field_151044_h, 8).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_coal"));
        TokenEnchantingRecipeBuilder.builder(CraftingItems.CHAOS_COAL, 6, 250, 20).token((ITag<Item>)GemsTags.Items.GEMS_CHAOS).addIngredient((IItemProvider)Items.field_196155_l, 8).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_coal2"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CORRUPTING_POWDER, 4, 50, 20).token(CraftingItems.CHAOS_DUST).addIngredient((ITag<Item>)GemsTags.Items.CORRUPTED_DUSTS, 2).addIngredient((ITag<Item>)Tags.Items.DUSTS_REDSTONE, 2).build(consumer);
        TokenEnchantingRecipeBuilder.builder(CraftingItems.ENDER_FROST, 1, 150, 20).token((IItemProvider)Blocks.field_205164_gk).addIngredient(CraftingItems.ENDER_CRYSTAL, 4).addIngredient((ITag<Item>)Tags.Items.GEMS_LAPIS, 8).build(consumer);
        TokenEnchantingRecipeBuilder.builder(CraftingItems.ENDER_SLIME_CRYSTAL, 1, 250, 100).token((ITag<Item>)Tags.Items.GEMS_DIAMOND).addIngredient(CraftingItems.ENDER_SLIME_BALL, 6).addIngredient(CraftingItems.ENRICHED_CHAOS_CRYSTAL, 2).build(consumer);
        TokenEnchantingRecipeBuilder.builder(CraftingItems.ENRICHED_CHAOS_CRYSTAL, 1, 150, 20).token((ITag<Item>)Tags.Items.GEMS_QUARTZ).addIngredient((ITag<Item>)GemsTags.Items.GEMS_CHAOS, 4).addIngredient((ITag<Item>)Tags.Items.DUSTS_GLOWSTONE, 4).build(consumer);
        TokenEnchantingRecipeBuilder.builder(CraftingItems.MAGMA_CREAM_CRYSTAL, 1, 250, 100).token((ITag<Item>)Tags.Items.GEMS_DIAMOND).addIngredient((IItemProvider)Items.field_151064_bs, 6).addIngredient(CraftingItems.ENRICHED_CHAOS_CRYSTAL, 2).build(consumer);
        TokenEnchantingRecipeBuilder.builder(GemsItems.PURIFYING_POWDER, 4, 50, 20).token(CraftingItems.CHAOS_DUST).addIngredient((ITag<Item>)GemsTags.Items.CORRUPTED_DUSTS, 2).addIngredient((ITag<Item>)Tags.Items.DUSTS_GLOWSTONE, 2).build(consumer);
        TokenEnchantingRecipeBuilder.builder(CraftingItems.SLIME_CRYSTAL, 1, 250, 100).token((ITag<Item>)Tags.Items.GEMS_DIAMOND).addIngredient((IItemProvider)Items.field_151123_aH, 6).addIngredient(CraftingItems.ENRICHED_CHAOS_CRYSTAL, 2).build(consumer);
        this.registerChaosRunes(consumer);
        this.registerEnchantmentTokens(consumer);
    }

    private void registerChaosRunes(Consumer<IFinishedRecipe> consumer) {
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("dolphins_grace")).token(CraftingItems.RUNE_SLATE).addIngredient((IItemProvider)Items.field_205158_fa, 1).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/dolphins_grace"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("fire_resistance")).token(CraftingItems.RUNE_SLATE).addIngredient((IItemProvider)Items.field_151064_bs, 6).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/fire_resistance"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("grounded")).token(CraftingItems.RUNE_SLATE).addIngredient(CraftingItems.LIGHTNING_WISP_ESSENCE, 4).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/grounded"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("haste")).token(CraftingItems.RUNE_SLATE).addIngredient((ITag<Item>)Tags.Items.DUSTS_GLOWSTONE, 16).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/haste"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("insulated")).token(CraftingItems.RUNE_SLATE).addIngredient(CraftingItems.ICE_WISP_ESSENCE, 4).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/insulated"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("invisibility")).token(CraftingItems.RUNE_SLATE).addIngredient((IItemProvider)Items.field_151071_bq, 4).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/invisibility"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("jump_boost")).token(CraftingItems.RUNE_SLATE).addIngredient((IItemProvider)Items.field_179556_br, 1).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/jump_boost"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("levitation")).token(CraftingItems.RUNE_SLATE).addIngredient((IItemProvider)Items.field_151061_bv, 2).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/levitation"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("night_vision")).token(CraftingItems.RUNE_SLATE).addIngredient((IItemProvider)Items.field_151150_bK, 3).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/night_vision"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("regeneration")).token(CraftingItems.RUNE_SLATE).addIngredient((IItemProvider)Items.field_151073_bk, 4).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/regeneration"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("resistance")).token(CraftingItems.RUNE_SLATE).addIngredient((ITag<Item>)Tags.Items.STORAGE_BLOCKS_IRON, 2).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/resistance"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("slow_falling")).token(CraftingItems.RUNE_SLATE).addIngredient((IItemProvider)Items.field_151008_G, 24).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/slow_falling"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("speed")).token(CraftingItems.RUNE_SLATE).addIngredient((IItemProvider)Items.field_151102_aT, 10).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/speed"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("strength")).token(CraftingItems.RUNE_SLATE).addIngredient((IItemProvider)Items.field_151065_br, 24).addIngredient((ITag<Item>)Tags.Items.DUSTS_REDSTONE, 6).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/strength"));
        TokenEnchantingRecipeBuilder.builder(GemsItems.CHAOS_RUNE, 1, 250, 100).chaosBuff(SilentGems.getId("water_breathing")).token(CraftingItems.RUNE_SLATE).addIngredient((ITag<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS, 2).addIngredient((IItemProvider)Items.field_196089_aZ, 1).build(consumer, GemsRecipeProvider.idTokenEnchanting("chaos_runes/water_breathing"));
    }

    private void registerEnchantmentTokens(Consumer<IFinishedRecipe> c) {
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185299_g, 200, 50, Gems.BENITOITE, (ITag<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS, 1);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_180312_n, 200, 50, Gems.AMETHYST, (IItemProvider)Items.field_151070_bp, 4);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185297_d, 100, 50, Gems.ONYX, (IItemProvider)Items.field_151016_H, 5);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_203196_F, 200, 50, Gems.YELLOW_DIAMOND, b -> b.addIngredient((ITag<Item>)Tags.Items.INGOTS_GOLD, 10).addIngredient((IItemProvider)Items.field_205157_eZ, 1));
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185300_i, 300, 100, Gems.EUCLASE, (IItemProvider)Items.field_221776_cx, 3);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185305_q, 100, 50, Gems.GREEN_SAPPHIRE, (ITag<Item>)Tags.Items.DUSTS_GLOWSTONE, 4);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_180309_e, 100, 50, Gems.MALACHITE, GemsTags.Items.FLUFFY_BLOCKS, 2);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_77334_n, 200, 100, Gems.GARNET, (IItemProvider)Items.field_151065_br, 8);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_77329_d, 100, 50, Gems.CITRINE, (IItemProvider)Items.field_151064_bs, 2);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185311_w, 200, 100, Gems.SPINEL, (ITag<Item>)Tags.Items.RODS_BLAZE, 2);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185308_t, 300, 100, Gems.ZIRCON, (ITag<Item>)Tags.Items.GEMS_DIAMOND, 3);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185301_j, 500, 200, Gems.MOONSTONE, b -> b.addIngredient(CraftingItems.ENDER_FROST, 4).addIngredient((IItemProvider)Items.field_222047_ii, 2));
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_203194_D, 200, 50, Gems.PYROPE, b -> b.addIngredient((IItemProvider)Items.field_151040_l, 1).addIngredient((IItemProvider)Items.field_205157_eZ, 1));
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185312_x, 400, 100, Gems.AMETRINE, b -> b.addIngredient((IItemProvider)Items.field_151061_bv, 6).addIngredient((IItemProvider)Items.field_151032_g, 64));
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_180313_o, 200, 50, Gems.AQUAMARINE, (ITag<Item>)Tags.Items.FEATHERS, 10);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185304_p, 300, 100, Gems.TURQUOISE, (ITag<Item>)Tags.Items.GEMS_EMERALD, 2);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_203193_C, 200, 50, Gems.KYANITE, b -> b.addIngredient((ITag<Item>)GemsTags.Items.WISP_ESSENCES, 4).addIngredient((IItemProvider)Items.field_205157_eZ, 1));
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_151370_z, 300, 100, Gems.AQUAMARINE, GemsTags.Items.STEW_FISH, 5);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_151369_A, 100, 50, Gems.PHOSPHOPHYLLITE, (IItemProvider)Items.field_221737_dE, 4);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185296_A, 500, 200, Gems.BLACK_DIAMOND, b -> b.addIngredient((IItemProvider)Items.field_151156_bN, 1).addIngredient(CraftingItems.MYSTERY_GOO, 2));
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_222192_G, 200, 50, Gems.PEARL, b -> b.addIngredient((IItemProvider)Items.field_221737_dE, 12).addIngredient((IItemProvider)Items.field_222114_py, 1));
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_222194_I, 200, 50, Gems.TEKTITE, b -> b.addIngredient((IItemProvider)Items.field_221790_de, 16).addIngredient((IItemProvider)Items.field_222114_py, 1));
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185309_u, 200, 50, Gems.CARNELIAN, (IItemProvider)Items.field_151032_g, 5);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_180308_g, 100, 50, Gems.AGATE, (IItemProvider)Items.field_151032_g, 4);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_180310_c, 100, 50, Gems.TANZANITE, (IItemProvider)Items.field_221790_de, 4);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185310_v, 200, 50, Gems.JASPER, (IItemProvider)Items.field_221602_aD, 2);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_222193_H, 200, 50, Gems.ROSE_QUARTZ, b -> b.addIngredient(CraftingItems.GILDED_STRING, 12).addIngredient((IItemProvider)Items.field_222114_py, 1));
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185298_f, 300, 50, Gems.IOLITE, (IItemProvider)Items.field_196089_aZ, 1);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_203195_E, 200, 50, Gems.APATITE, b -> b.addIngredient((ITag<Item>)Tags.Items.FEATHERS, 20).addIngredient((IItemProvider)Items.field_205157_eZ, 1));
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185302_k, 200, 50, Gems.RUBY, (IItemProvider)Items.field_151145_ak, 5);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185306_r, 500, 100, Gems.ALEXANDRITE, (ITag<Item>)Tags.Items.GEMS_EMERALD, 3);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185303_l, 200, 50, Gems.PERIDOT, (IItemProvider)Items.field_151078_bh, 12);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_234847_l_, 300, 100, Gems.EUCLASE, (IItemProvider)Items.field_234734_dm_, 20);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_191530_r, 100, 50, Gems.MOLDAVITE, (IItemProvider)Items.field_222065_kN, 5);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_92091_k, 250, 100, Gems.TOPAZ, (IItemProvider)Items.field_221912_fn, 7);
        GemsRecipeProvider.enchantedTokenRecipe(c, Enchantments.field_185307_s, 100, 50, Gems.SAPPHIRE, (ITag<Item>)Tags.Items.INGOTS_IRON, 5);
        GemsRecipeProvider.enchantedTokenRecipe(c, (Enchantment)GemsEnchantments.GRAVITY.get(), 250, 100, Gems.AMBER, CraftingItems.NETHER_STAR_SHARD, 1);
        GemsRecipeProvider.enchantedTokenRecipe(c, (Enchantment)GemsEnchantments.ICE_ASPECT.get(), 200, 100, Gems.OPAL, (IItemProvider)Items.field_221770_cu, 8);
        GemsRecipeProvider.enchantedTokenRecipe(c, (Enchantment)GemsEnchantments.LIFE_STEAL.get(), 300, 100, Gems.MORGANITE, (IItemProvider)Items.field_151153_ao, 3);
        GemsRecipeProvider.enchantedTokenRecipe(c, (Enchantment)GemsEnchantments.LIGHTNING_ASPECT.get(), 200, 100, Gems.HELIODOR, (ITag<Item>)Tags.Items.DUSTS_GLOWSTONE, 4);
    }

    private static void enchantedTokenRecipe(Consumer<IFinishedRecipe> consumer, Enchantment enchantment, int chaosGenerated, int processTime, Gems gem, IItemProvider other, int otherCount) {
        ResourceLocation id = NameUtils.from((IForgeRegistryEntry)enchantment);
        TokenEnchantingRecipeBuilder.builder(GemsItems.ENCHANTMENT_TOKEN, 1, chaosGenerated, processTime).enchantment(enchantment, 1).token(CraftingItems.BLANK_TOKEN).addIngredient((ITag<Item>)gem.getItemTag(), 2).addIngredient(other, otherCount).build(consumer, GemsRecipeProvider.idTokenEnchanting("enchantment/" + id.func_110624_b() + "." + id.func_110623_a()));
    }

    private static void enchantedTokenRecipe(Consumer<IFinishedRecipe> consumer, Enchantment enchantment, int chaosGenerated, int processTime, Gems gem, ITag<Item> other, int otherCount) {
        ResourceLocation id = NameUtils.from((IForgeRegistryEntry)enchantment);
        TokenEnchantingRecipeBuilder.builder(GemsItems.ENCHANTMENT_TOKEN, 1, chaosGenerated, processTime).enchantment(enchantment, 1).token(CraftingItems.BLANK_TOKEN).addIngredient((ITag<Item>)gem.getItemTag(), 2).addIngredient(other, otherCount).build(consumer, GemsRecipeProvider.idTokenEnchanting("enchantment/" + id.func_110624_b() + "." + id.func_110623_a()));
    }

    private static void enchantedTokenRecipe(Consumer<IFinishedRecipe> consumer, Enchantment enchantment, int chaosGenerated, int processTime, Gems gem, Consumer<TokenEnchantingRecipeBuilder> otherIngredients) {
        ResourceLocation id = NameUtils.from((IForgeRegistryEntry)enchantment);
        TokenEnchantingRecipeBuilder builder = TokenEnchantingRecipeBuilder.builder(GemsItems.ENCHANTMENT_TOKEN, 1, chaosGenerated, processTime).enchantment(enchantment, 1).token(CraftingItems.BLANK_TOKEN).addIngredient((ITag<Item>)gem.getItemTag(), 2);
        otherIngredients.accept(builder);
        builder.build(consumer, GemsRecipeProvider.idTokenEnchanting("enchantment/" + id.func_110624_b() + "." + id.func_110623_a()));
    }

    private static ResourceLocation idTokenEnchanting(String path) {
        return SilentGems.getId("token_enchanting/" + path);
    }

    private void registerFluffyStuff(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)CraftingItems.FLUFFY_FABRIC).func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), (IItemProvider)CraftingItems.FLUFFY_PUFF).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.FLUFFY_PUFF)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)CraftingItems.FLUFFY_PUFF, (int)4).func_200487_b((IItemProvider)CraftingItems.FLUFFY_FABRIC).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.FLUFFY_PUFF)).func_200485_a(consumer, SilentGems.getId("fluffy_puff_from_fabric"));
        ShapedRecipeBuilder.func_200470_a(GemsBlocks.WHITE_FLUFFY_BLOCK).func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), (IItemProvider)CraftingItems.FLUFFY_FABRIC).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.FLUFFY_PUFF)).func_200467_a(consumer, SilentGems.getId("fluffy_block_base"));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)CraftingItems.FLUFFY_FABRIC, (int)4).func_203221_a(GemsTags.Items.FLUFFY_BLOCKS).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.FLUFFY_PUFF)).func_200485_a(consumer, SilentGems.getId("fluffy_fabric_from_block"));
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.WHITE_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_WHITE);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.ORANGE_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_ORANGE);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.MAGENTA_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_MAGENTA);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.LIGHT_BLUE_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_LIGHT_BLUE);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.YELLOW_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_YELLOW);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.LIME_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_LIME);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.PINK_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_PINK);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.GRAY_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_GRAY);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.LIGHT_GRAY_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_LIGHT_GRAY);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.CYAN_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_CYAN);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.PURPLE_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_PURPLE);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.BLUE_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_BLUE);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.BROWN_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_BROWN);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.GREEN_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_GREEN);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.RED_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_RED);
        this.dyeFluffyBlock(consumer, (IItemProvider)GemsBlocks.BLACK_FLUFFY_BLOCK, (ITag<Item>)Tags.Items.DYES_BLACK);
        ShapelessRecipeBuilder.func_200486_a(GemsItems.FLUFFY_PUFF_SEEDS).func_200487_b((IItemProvider)CraftingItems.FLUFFY_PUFF).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.FLUFFY_PUFF)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151008_G).func_200472_a(" ##").func_200472_a("## ").func_200472_a("#  ").func_200462_a(Character.valueOf('#'), (IItemProvider)CraftingItems.FLUFFY_PUFF).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.FLUFFY_PUFF)).func_200467_a(consumer, SilentGems.getId("fluffy_feather"));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151007_F).func_200487_b((IItemProvider)CraftingItems.FLUFFY_PUFF).func_200487_b((IItemProvider)CraftingItems.FLUFFY_PUFF).func_200483_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.FLUFFY_PUFF)).func_200485_a(consumer, SilentGems.getId("fluffy_string"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_221603_aE).func_200472_a("###").func_200472_a("# #").func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)CraftingItems.FLUFFY_PUFF).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a((IItemProvider)CraftingItems.FLUFFY_PUFF)).func_200467_a(consumer, SilentGems.getId("fluffy_wool"));
    }

    private void dyeFluffyBlock(Consumer<IFinishedRecipe> consumer, IItemProvider block, ITag<Item> dye) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)block, (int)8).func_200472_a("###").func_200472_a("#d#").func_200472_a("###").func_200469_a(Character.valueOf('#'), GemsTags.Items.FLUFFY_BLOCKS).func_200469_a(Character.valueOf('d'), dye).func_200465_a("has_item", (ICriterionInstance)GemsRecipeProvider.func_200403_a(GemsBlocks.WHITE_FLUFFY_BLOCK)).func_200464_a(consumer);
    }
}

