/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.function.Supplier;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Potion;
import net.minecraftforge.fml.RegistryObject;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.potion.BaseEffect;
import net.silentchaos512.gems.potion.FreezingEffect;
import net.silentchaos512.gems.potion.ShockingEffect;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.Color;

public final class GemsEffects {
    public static final RegistryObject<FreezingEffect> FREEZING = GemsEffects.registerEffect("freezing", FreezingEffect::new);
    public static final RegistryObject<ShockingEffect> SHOCKING = GemsEffects.registerEffect("shocking", ShockingEffect::new);
    public static final RegistryObject<Effect> INSULATED = GemsEffects.registerEffect("insulated", () -> new BaseEffect(EffectType.BENEFICIAL, 38041));
    public static final RegistryObject<Effect> GROUNDED = GemsEffects.registerEffect("grounded", () -> new BaseEffect(EffectType.BENEFICIAL, 0x919900));
    public static final RegistryObject<Effect> CHAOS_SICKNESS = GemsEffects.registerEffect("chaos_sickness", () -> new BaseEffect(EffectType.HARMFUL, Color.MEDIUMPURPLE.getColor()));
    public static final RegistryObject<Potion> INSULATING_POTION = GemsEffects.registerPotion("insulating", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)INSULATED.get(), TimeUtils.ticksFromMinutes((float)3.0f))}));
    public static final RegistryObject<Potion> GROUNDING_POTION = GemsEffects.registerPotion("grounding", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)GROUNDED.get(), TimeUtils.ticksFromMinutes((float)3.0f))}));

    private GemsEffects() {
    }

    static void register() {
    }

    private static <T extends Effect> RegistryObject<T> registerEffect(String name, Supplier<T> effect) {
        return Registration.EFFECTS.register(name, effect);
    }

    private static <T extends Potion> RegistryObject<T> registerPotion(String name, Supplier<T> potion) {
        return Registration.POTIONS.register(name, potion);
    }
}

