/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.IGem;
import net.silentchaos512.lib.util.DimPos;
import net.silentchaos512.lib.util.TeleportUtils;

public class ReturnHomeCharmItem
extends Item
implements IGem {
    private static final String NBT_READY = "IsReady";
    private final Gems gem;

    public ReturnHomeCharmItem(Gems gem) {
        super(new Item.Properties().func_200916_a(GemsItemGroups.UTILITY).func_200917_a(1));
        this.gem = gem;
    }

    @Override
    public Gems getGem() {
        return this.gem;
    }

    @Nullable
    public static DimPos getBoundPosition(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        DimPos pos = DimPos.read((CompoundNBT)stack.func_196082_o());
        if (pos.equals((Object)DimPos.ZERO)) {
            return null;
        }
        return pos;
    }

    public int getTeleportCost(ItemStack stack, PlayerEntity player) {
        return Chaos.getChaosGeneratedByTeleport((Entity)player, ReturnHomeCharmItem.getBoundPosition(stack));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add((ITextComponent)new TranslationTextComponent("item.silentgems.return_home_charm.desc"));
        DimPos pos = ReturnHomeCharmItem.getBoundPosition(stack);
        if (pos != null) {
            if (KeyTracker.isControlDown()) {
                list.add((ITextComponent)new TranslationTextComponent("item.silentgems.return_home_charm.boundTo", new Object[]{pos}));
            } else {
                list.add((ITextComponent)new TranslationTextComponent("misc.silentgems.pressCtrl"));
            }
        } else {
            list.add((ITextComponent)new TranslationTextComponent("item.silentgems.return_home_charm.notBound"));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return this.func_200296_o();
    }

    public ITextComponent func_200296_o() {
        return new TranslationTextComponent("item.silentgems.return_home_charm", new Object[]{this.gem.getDisplayName()});
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0 && stack.func_77973_b() instanceof ReturnHomeCharmItem) {
            ReturnHomeCharmItem item = (ReturnHomeCharmItem)stack.func_77973_b();
            return item.gem.getColor();
        }
        return 0xFFFFFF;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 133700;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)GemsConfig.Common.returnHomeMaxUses.get();
    }

    public boolean func_77645_m() {
        return (Integer)GemsConfig.Common.returnHomeMaxUses.get() > 0;
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_196082_o().func_74767_n(NBT_READY);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        DimPos pos = ReturnHomeCharmItem.getBoundPosition(stack);
        if (pos != null) {
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        player.func_145747_a((ITextComponent)new TranslationTextComponent("item.silentgems.return_home_charm.notBound"), Util.field_240973_b_);
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        int timeUsed;
        if (player.field_70170_p.field_72995_K && (timeUsed = this.func_77626_a(stack) - count) >= (Integer)GemsConfig.Common.returnHomeUseTime.get()) {
            stack.func_196082_o().func_74757_a(NBT_READY, true);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!isSelected && stack.func_196082_o().func_74767_n(NBT_READY)) {
            stack.func_196082_o().func_74757_a(NBT_READY, false);
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int timeLeft) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (world.field_72995_K) {
            stack.func_196082_o().func_74757_a(NBT_READY, false);
        } else {
            int timeUsed = this.func_77626_a(stack) - timeLeft;
            if (timeUsed >= (Integer)GemsConfig.Common.returnHomeUseTime.get()) {
                this.tryTeleportPlayer(stack, player);
                if (this.func_77645_m() && player instanceof ServerPlayerEntity) {
                    stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(p.func_184600_cs()));
                }
            }
        }
    }

    public void tryTeleportPlayer(ItemStack stack, PlayerEntity player) {
        DimPos pos = ReturnHomeCharmItem.getBoundPosition(stack);
        if (pos == null || !(player instanceof ServerPlayerEntity)) {
            return;
        }
        if (pos.getY() <= 0) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("teleporter.silentgems.notSane"), Util.field_240973_b_);
            return;
        }
        player.field_70143_R = 0.0f;
        float soundPitch = 0.8f + 0.3f * SilentGems.random.nextFloat();
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, soundPitch);
        TeleportUtils.teleport((PlayerEntity)player, (DimPos)pos.offset(Direction.UP, 1), null);
        Chaos.generate(player, this.getTeleportCost(stack, player), true);
        player.field_70170_p.func_184133_a(null, pos.getPos(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, soundPitch);
    }
}

