/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.lib.urn.IUrnUpgradeItem;
import net.silentchaos512.gems.lib.urn.UpgradePlanter;
import net.silentchaos512.gems.lib.urn.UpgradeVacuum;
import net.silentchaos512.gems.lib.urn.UrnUpgrade;
import net.silentchaos512.lib.registry.ItemRegistryObject;

public enum SoulUrnUpgrades implements IItemProvider
{
    EXTRA_STORAGE(SoulUrnUpgrades.basicSerializer("extra_storage", UrnUpgrade::new)),
    VACUUM(SoulUrnUpgrades.basicSerializer("vacuum", UpgradeVacuum::new)),
    PLANTER(SoulUrnUpgrades.basicSerializer("planter", UpgradePlanter::new));

    private ItemRegistryObject<UpgradeItem> item;
    private final UrnUpgrade.Serializer<? extends UrnUpgrade> serializer;

    private SoulUrnUpgrades(UrnUpgrade.Serializer<? extends UrnUpgrade> serializer) {
        this.serializer = serializer;
    }

    public static void registerItems() {
        for (SoulUrnUpgrades upgrade : SoulUrnUpgrades.values()) {
            upgrade.item = new ItemRegistryObject(Registration.ITEMS.register(upgrade.getName(), () -> new UpgradeItem(upgrade)));
        }
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT) + "_urn_upgrade";
    }

    public UpgradeItem asItem() {
        return (UpgradeItem)this.item.get();
    }

    public UrnUpgrade.Serializer<? extends UrnUpgrade> getSerializer() {
        return this.serializer;
    }

    private static UrnUpgrade.Serializer<UrnUpgrade> basicSerializer(String name, Supplier<UrnUpgrade> constructor) {
        return new UrnUpgrade.Serializer<UrnUpgrade>(new ResourceLocation("silentgems", name), constructor);
    }

    public static class UpgradeItem
    extends Item
    implements IUrnUpgradeItem {
        private final SoulUrnUpgrades type;

        UpgradeItem(SoulUrnUpgrades type) {
            super(new Item.Properties().func_200916_a(GemsItemGroups.UTILITY));
            this.type = type;
        }

        @Override
        public UrnUpgrade.Serializer<? extends UrnUpgrade> getSerializer() {
            return this.type.serializer;
        }
    }
}

