/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.misc.EnergyType;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.common.block.FluxDeviceBlock;
import sonar.fluxnetworks.common.tileentity.TileFluxStorage;

public abstract class FluxStorageBlock
extends FluxDeviceBlock {
    public FluxStorageBlock(AbstractBlock.Properties props) {
        super(props);
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable IBlockReader worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)FluxTranslate.FLUX_STORAGE_TOOLTIP.getTextComponent());
        tooltip.add((ITextComponent)FluxTranslate.FLUX_STORAGE_TOOLTIP_2.getTextComponent(EnergyType.storage(this.getEnergyCapacity())));
    }

    public abstract long getEnergyCapacity();

    public static class Gargantuan
    extends FluxStorageBlock {
        public Gargantuan(AbstractBlock.Properties props) {
            super(props);
        }

        @Override
        public long getEnergyCapacity() {
            return FluxConfig.gargantuanCapacity;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new TileFluxStorage.Gargantuan();
        }
    }

    public static class Herculean
    extends FluxStorageBlock {
        public Herculean(AbstractBlock.Properties props) {
            super(props);
        }

        @Override
        public long getEnergyCapacity() {
            return FluxConfig.herculeanCapacity;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new TileFluxStorage.Herculean();
        }
    }

    public static class Basic
    extends FluxStorageBlock {
        public Basic(AbstractBlock.Properties props) {
            super(props);
        }

        @Override
        public long getEnergyCapacity() {
            return FluxConfig.basicCapacity;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new TileFluxStorage.Basic();
        }
    }
}

