/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.GlobalPos;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.NetworkSecurity;
import sonar.fluxnetworks.common.capability.SuperAdmin;
import sonar.fluxnetworks.common.connection.NetworkStatistics;
import sonar.fluxnetworks.common.connection.PhantomFluxDevice;
import sonar.fluxnetworks.common.misc.FluxUtils;

public class BasicFluxNetwork
implements IFluxNetwork {
    private static final String NETWORK_NAME = "networkName";
    private static final String NETWORK_COLOR = "networkColor";
    private static final String OWNER_UUID = "ownerUUID";
    private static final String PLAYER_LIST = "playerList";
    private static final String CONNECTIONS = "connections";
    private static final String WIRELESS_MODE = "wirelessMode";
    private int networkID;
    private String networkName;
    private int networkColor;
    private UUID ownerUUID;
    private int wirelessMode;
    protected final NetworkSecurity security = new NetworkSecurity();
    protected final NetworkStatistics statistics = new NetworkStatistics(this);
    protected final Object2ObjectMap<UUID, NetworkMember> members = new Object2ObjectOpenHashMap();
    protected final Object2ObjectMap<GlobalPos, IFluxDevice> allConnections = new Object2ObjectOpenHashMap();

    public BasicFluxNetwork() {
    }

    protected BasicFluxNetwork(int id, String name, int color, UUID owner) {
        this.networkID = id;
        this.networkName = name;
        this.networkColor = color;
        this.ownerUUID = owner;
    }

    protected BasicFluxNetwork(int id, String name, int color, @Nonnull PlayerEntity creator) {
        this.networkID = id;
        this.networkName = name;
        this.networkColor = color;
        this.ownerUUID = PlayerEntity.func_146094_a((GameProfile)creator.func_146103_bH());
        this.members.put((Object)this.ownerUUID, (Object)NetworkMember.create(creator, AccessLevel.OWNER));
    }

    @Override
    public int getNetworkID() {
        return this.networkID;
    }

    @Override
    public String getNetworkName() {
        return this.networkName;
    }

    @Override
    public void setNetworkName(String name) {
        this.networkName = name;
    }

    @Override
    public int getNetworkColor() {
        return this.networkColor;
    }

    @Override
    public void setNetworkColor(int color) {
        this.networkColor = color;
    }

    @Override
    public int getWirelessMode() {
        return this.wirelessMode;
    }

    @Override
    public void setWirelessMode(int wireless) {
        this.wirelessMode = wireless;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public NetworkSecurity getSecurity() {
        return this.security;
    }

    @Override
    public NetworkStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public Collection<NetworkMember> getAllMembers() {
        return this.members.values();
    }

    @Override
    public Object2ObjectMap<UUID, NetworkMember> getRawMemberMap() {
        return this.members;
    }

    @Override
    public Collection<IFluxDevice> getAllConnections() {
        return this.allConnections.values();
    }

    @Override
    @Nullable
    public Optional<IFluxDevice> getConnectionByPos(GlobalPos pos) {
        return Optional.ofNullable((IFluxDevice)this.allConnections.get((Object)pos));
    }

    @Override
    public void onEndServerTick() {
        throw new IllegalStateException();
    }

    @Override
    public void onDelete() {
    }

    @Override
    @Nonnull
    public AccessLevel getPlayerAccess(PlayerEntity player) {
        throw new IllegalStateException();
    }

    @Override
    @Nonnull
    public <T extends IFluxDevice> List<T> getConnections(FluxLogicType type) {
        throw new IllegalStateException();
    }

    @Override
    public Optional<NetworkMember> getMemberByUUID(UUID playerUUID) {
        return Optional.ofNullable((NetworkMember)this.members.get((Object)playerUUID));
    }

    @Override
    public long getBufferLimiter() {
        throw new IllegalStateException();
    }

    @Override
    public void markSortConnections() {
        throw new IllegalStateException();
    }

    @Override
    public void enqueueConnectionAddition(@Nonnull IFluxDevice device) {
        throw new IllegalStateException();
    }

    @Override
    public void enqueueConnectionRemoval(@Nonnull IFluxDevice device, boolean chunkUnload) {
        throw new IllegalStateException();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, int type) {
        ObjectCollection connections;
        CompoundNBT t1;
        ListNBT list;
        ObjectCollection members;
        if (type == 21 || type == 1) {
            nbt.func_74768_a("networkID", this.networkID);
            nbt.func_74778_a(NETWORK_NAME, this.networkName);
            nbt.func_74768_a(NETWORK_COLOR, this.networkColor);
            nbt.func_186854_a(OWNER_UUID, this.ownerUUID);
            nbt.func_74768_a(WIRELESS_MODE, this.wirelessMode);
            this.security.writeNBT(nbt, type == 1);
        }
        if (type == 1) {
            ObjectCollection connections2;
            members = this.members.values();
            if (!members.isEmpty()) {
                list = new ListNBT();
                for (Object m : members) {
                    t1 = new CompoundNBT();
                    ((NetworkMember)m).writeNBT(t1);
                    list.add((Object)t1);
                }
                nbt.func_218657_a(PLAYER_LIST, (INBT)list);
            }
            if (!(connections2 = this.allConnections.values()).isEmpty()) {
                ListNBT list2 = new ListNBT();
                for (IFluxDevice d : connections2) {
                    if (d.isChunkLoaded()) continue;
                    CompoundNBT t12 = new CompoundNBT();
                    d.writeCustomNBT(t12, 1);
                    list2.add((Object)t12);
                }
                nbt.func_218657_a(CONNECTIONS, (INBT)list2);
            }
        }
        if (type == 22) {
            members = this.members.values();
            list = new ListNBT();
            for (Object m : members) {
                t1 = new CompoundNBT();
                ((NetworkMember)m).writeNBT(t1);
                list.add((Object)t1);
            }
            List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
            if (!players.isEmpty()) {
                players.stream().filter(arg_0 -> BasicFluxNetwork.lambda$writeCustomNBT$1((Collection)members, arg_0)).forEach(valid -> {
                    CompoundNBT t1 = new CompoundNBT();
                    NetworkMember m = NetworkMember.create((PlayerEntity)valid, SuperAdmin.isPlayerSuperAdmin((PlayerEntity)valid) ? AccessLevel.SUPER_ADMIN : AccessLevel.BLOCKED);
                    m.writeNBT(t1);
                    list.add((Object)t1);
                });
            }
            nbt.func_218657_a(PLAYER_LIST, (INBT)list);
        }
        if (type == 23 && !(connections = this.allConnections.values()).isEmpty()) {
            list = new ListNBT();
            for (IFluxDevice d : connections) {
                t1 = new CompoundNBT();
                d.writeCustomNBT(t1, 20);
                list.add((Object)t1);
            }
            nbt.func_218657_a(CONNECTIONS, (INBT)list);
        }
        if (type == 24) {
            this.statistics.writeNBT(nbt);
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, int type) {
        NetworkMember m;
        CompoundNBT c;
        int i;
        ListNBT list;
        if (type == 21 || type == 1) {
            this.networkID = nbt.func_74762_e("networkID");
            this.networkName = nbt.func_74779_i(NETWORK_NAME);
            this.networkColor = nbt.func_74762_e(NETWORK_COLOR);
            this.ownerUUID = nbt.func_186857_a(OWNER_UUID);
            this.wirelessMode = nbt.func_74762_e(WIRELESS_MODE);
            this.security.readNBT(nbt);
        }
        if (type == 1) {
            list = nbt.func_150295_c(PLAYER_LIST, 10);
            for (i = 0; i < list.size(); ++i) {
                c = list.func_150305_b(i);
                m = new NetworkMember(c);
                this.members.put((Object)m.getPlayerUUID(), (Object)m);
            }
            list = nbt.func_150295_c(CONNECTIONS, 10);
            for (i = 0; i < list.size(); ++i) {
                c = list.func_150305_b(i);
                PhantomFluxDevice f = new PhantomFluxDevice();
                f.readCustomNBT(c, 1);
                this.allConnections.put((Object)f.getGlobalPos(), (Object)f);
            }
        }
        if (type == 22) {
            this.members.clear();
            list = nbt.func_150295_c(PLAYER_LIST, 10);
            for (i = 0; i < list.size(); ++i) {
                c = list.func_150305_b(i);
                m = new NetworkMember(c);
                this.members.put((Object)m.getPlayerUUID(), (Object)m);
            }
        }
        if (type == 23) {
            this.allConnections.clear();
            list = nbt.func_150295_c(CONNECTIONS, 10);
            for (i = 0; i < list.size(); ++i) {
                c = list.func_150305_b(i);
                GlobalPos pos = FluxUtils.readGlobalPos(c);
                IFluxDevice f = (IFluxDevice)this.allConnections.get((Object)pos);
                if (f != null) {
                    f.readCustomNBT(c, 20);
                    continue;
                }
                this.allConnections.put((Object)pos, (Object)new PhantomFluxDevice(pos, c));
            }
        }
        if (type == 24) {
            this.statistics.readNBT(nbt);
        }
    }

    private static /* synthetic */ boolean lambda$writeCustomNBT$1(Collection members, ServerPlayerEntity p) {
        return members.stream().noneMatch(c -> c.getPlayerUUID().equals(p.func_110124_au()));
    }
}

